/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class MappingUpdatedAction
extends TransportMasterNodeOperationAction<MappingUpdatedRequest, MappingUpdatedResponse> {
    private final MetaDataMappingService metaDataMappingService;

    @Inject
    public MappingUpdatedAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataMappingService metaDataMappingService) {
        super(settings, transportService, clusterService, threadPool);
        this.metaDataMappingService = metaDataMappingService;
    }

    @Override
    protected String transportAction() {
        return "cluster/mappingUpdated";
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected MappingUpdatedRequest newRequest() {
        return new MappingUpdatedRequest();
    }

    @Override
    protected MappingUpdatedResponse newResponse() {
        return new MappingUpdatedResponse();
    }

    @Override
    protected MappingUpdatedResponse masterOperation(MappingUpdatedRequest request, ClusterState state) throws ElasticSearchException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<Exception> failure = new AtomicReference<Exception>();
        try {
            this.metaDataMappingService.updateMapping(request.index(), request.type(), request.mappingSource(), new MetaDataMappingService.Listener(){

                @Override
                public void onResponse(MetaDataMappingService.Response response) {
                    latch.countDown();
                }

                @Override
                public void onFailure(Throwable t) {
                    failure.set(t);
                    latch.countDown();
                }
            });
        }
        catch (Exception e) {
            failure.set(e);
        }
        if (failure.get() != null) {
            if (failure.get() instanceof ElasticSearchException) {
                throw (ElasticSearchException)failure.get();
            }
            throw new ElasticSearchException("failed to update mapping", (Throwable)failure.get());
        }
        return new MappingUpdatedResponse();
    }

    public static class MappingUpdatedRequest
    extends MasterNodeOperationRequest {
        private String index;
        private String type;
        private CompressedString mappingSource;

        MappingUpdatedRequest() {
        }

        public MappingUpdatedRequest(String index, String type, CompressedString mappingSource) {
            this.index = index;
            this.type = type;
            this.mappingSource = mappingSource;
        }

        public String index() {
            return this.index;
        }

        public String type() {
            return this.type;
        }

        public CompressedString mappingSource() {
            return this.mappingSource;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.index = in.readUTF();
            this.type = in.readUTF();
            this.mappingSource = CompressedString.readCompressedString(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeUTF(this.index);
            out.writeUTF(this.type);
            this.mappingSource.writeTo(out);
        }
    }

    public static class MappingUpdatedResponse
    implements ActionResponse {
        @Override
        public void readFrom(StreamInput in) throws IOException {
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }
    }
}

