/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import org.elasticsearch.cluster.routing.operation.hash.djb.DjbHashFunction;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class MetaDataService
extends AbstractComponent {
    private final MdLock[] indexMdLocks = new MdLock[500];

    @Inject
    public MetaDataService(Settings settings) {
        super(settings);
        for (int i = 0; i < this.indexMdLocks.length; ++i) {
            this.indexMdLocks[i] = new MdLock();
        }
    }

    public MdLock indexMetaDataLock(String index) {
        return this.indexMdLocks[Math.abs(DjbHashFunction.DJB_HASH(index) % this.indexMdLocks.length)];
    }

    public class MdLock {
        private boolean isLocked = false;

        public synchronized void lock() throws InterruptedException {
            while (this.isLocked) {
                this.wait();
            }
            this.isLocked = true;
        }

        public synchronized void unlock() {
            this.isLocked = false;
            this.notifyAll();
        }
    }
}

