/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.collect.Lists;

public class RoutingNode
implements Iterable<MutableShardRouting> {
    private final String nodeId;
    private final DiscoveryNode node;
    private final List<MutableShardRouting> shards;

    public RoutingNode(String nodeId, DiscoveryNode node) {
        this(nodeId, node, new ArrayList<MutableShardRouting>());
    }

    public RoutingNode(String nodeId, DiscoveryNode node, List<MutableShardRouting> shards) {
        this.nodeId = nodeId;
        this.node = node;
        this.shards = shards;
    }

    @Override
    public Iterator<MutableShardRouting> iterator() {
        return this.shards.iterator();
    }

    public DiscoveryNode node() {
        return this.node;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public List<MutableShardRouting> shards() {
        return this.shards;
    }

    public void add(MutableShardRouting shard) {
        this.shards.add(shard);
        shard.assignToNode(this.node.id());
    }

    public void removeByShardId(int shardId) {
        Iterator<MutableShardRouting> it = this.shards.iterator();
        while (it.hasNext()) {
            MutableShardRouting shard = it.next();
            if (shard.id() != shardId) continue;
            it.remove();
        }
    }

    public int numberOfShardsWithState(ShardRoutingState ... states) {
        int count = 0;
        for (MutableShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                ++count;
            }
        }
        return count;
    }

    public List<MutableShardRouting> shardsWithState(ShardRoutingState ... states) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (MutableShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public List<MutableShardRouting> shardsWithState(String index, ShardRoutingState ... states) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (MutableShardRouting shardEntry : this) {
            if (!shardEntry.index().equals(index)) continue;
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public int numberOfShardsNotWithState(ShardRoutingState state) {
        int count = 0;
        for (MutableShardRouting shardEntry : this) {
            if (shardEntry.state() == state) continue;
            ++count;
        }
        return count;
    }

    public int numberOfOwningShards() {
        int count = 0;
        for (MutableShardRouting shardEntry : this) {
            if (shardEntry.state() == ShardRoutingState.RELOCATING) continue;
            ++count;
        }
        return count;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----node_id[").append(this.nodeId).append("][" + (this.node == null ? "X" : "V") + "]\n");
        for (MutableShardRouting entry : this.shards) {
            sb.append("--------").append(entry.shortSummary()).append('\n');
        }
        return sb.toString();
    }
}

