/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import org.elasticsearch.common.compress.lzf.BufferRecycler;
import org.elasticsearch.common.compress.lzf.ChunkEncoder;
import org.elasticsearch.common.compress.lzf.LZFChunk;

public class LZFEncoder {
    private LZFEncoder() {
    }

    public static byte[] encode(byte[] data) throws IOException {
        return LZFEncoder.encode(data, data.length);
    }

    public static byte[] encode(byte[] data, int length) throws IOException {
        return LZFEncoder.encode(data, 0, length);
    }

    public static byte[] encode(byte[] data, int offset, int length) throws IOException {
        ChunkEncoder enc = new ChunkEncoder(length, BufferRecycler.instance());
        byte[] result = LZFEncoder.encode(enc, data, offset, length);
        enc.close();
        return result;
    }

    public static byte[] encode(ChunkEncoder enc, byte[] data, int length) throws IOException {
        return LZFEncoder.encode(enc, data, 0, length);
    }

    public static byte[] encode(ChunkEncoder enc, byte[] data, int offset, int length) throws IOException {
        int left = length;
        int chunkLen = Math.min(65535, left);
        LZFChunk first = enc.encodeChunk(data, offset, chunkLen);
        if ((left -= chunkLen) < 1) {
            return first.getData();
        }
        int resultBytes = first.length();
        offset += chunkLen;
        LZFChunk last = first;
        do {
            chunkLen = Math.min(left, 65535);
            LZFChunk chunk = enc.encodeChunk(data, offset, chunkLen);
            offset += chunkLen;
            resultBytes += chunk.length();
            last.setNext(chunk);
            last = chunk;
        } while ((left -= chunkLen) > 0);
        byte[] result = new byte[resultBytes];
        int ptr = 0;
        while (first != null) {
            ptr = first.copyTo(result, ptr);
            first = first.next();
        }
        return result;
    }
}

