/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lab;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.Preconditions;

public class LongsLAB {
    private AtomicReference<Chunk> curChunk = new AtomicReference();
    final int chunkSize;
    final int maxAlloc;

    public LongsLAB(int chunkSize, int maxAlloc) {
        this.chunkSize = chunkSize;
        this.maxAlloc = maxAlloc;
        Preconditions.checkArgument(maxAlloc <= chunkSize);
    }

    public Allocation allocateLongs(int size) {
        Preconditions.checkArgument(size >= 0, "negative size");
        if (size > this.maxAlloc) {
            return null;
        }
        Chunk c;
        int allocOffset;
        while ((allocOffset = (c = this.getOrMakeChunk()).alloc(size)) == -1) {
            this.tryRetireChunk(c);
        }
        return new Allocation(c.data, allocOffset);
    }

    private void tryRetireChunk(Chunk c) {
        boolean weRetiredIt = this.curChunk.compareAndSet(c, null);
    }

    private Chunk getOrMakeChunk() {
        Chunk c;
        do {
            if ((c = this.curChunk.get()) == null) continue;
            return c;
        } while (!this.curChunk.compareAndSet(null, c = new Chunk(this.chunkSize)));
        c.init();
        return c;
    }

    public static class Allocation {
        private final long[] data;
        private final int offset;

        private Allocation(long[] data, int off) {
            this.data = data;
            this.offset = off;
        }

        public String toString() {
            return "Allocation(data=" + this.data + " with capacity=" + this.data.length + ", off=" + this.offset + ")";
        }

        public long[] getData() {
            return this.data;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    private static class Chunk {
        private long[] data;
        private static final int UNINITIALIZED = -1;
        private static final int OOM = -2;
        private AtomicInteger nextFreeOffset = new AtomicInteger(-1);
        private AtomicInteger allocCount = new AtomicInteger();
        private final int size;

        private Chunk(int size) {
            this.size = size;
        }

        public void init() {
            assert (this.nextFreeOffset.get() == -1);
            try {
                this.data = new long[this.size];
            }
            catch (OutOfMemoryError e) {
                boolean failInit = this.nextFreeOffset.compareAndSet(-1, -2);
                assert (failInit);
                throw e;
            }
            boolean initted = this.nextFreeOffset.compareAndSet(-1, 0);
            Preconditions.checkState(initted, "Multiple threads tried to init same chunk");
        }

        public int alloc(int size) {
            int oldOffset;
            while (true) {
                if ((oldOffset = this.nextFreeOffset.get()) == -1) {
                    Thread.yield();
                    continue;
                }
                if (oldOffset == -2) {
                    return -1;
                }
                if (oldOffset + size > this.data.length) {
                    return -1;
                }
                if (this.nextFreeOffset.compareAndSet(oldOffset, oldOffset + size)) break;
            }
            this.allocCount.incrementAndGet();
            return oldOffset;
        }

        public String toString() {
            return "Chunk@" + System.identityHashCode(this) + " allocs=" + this.allocCount.get() + "waste=" + (this.data.length - this.nextFreeOffset.get());
        }
    }
}

