/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.elasticsearch.common.lucene.docset.DocSet;

public class AllDocSet
extends DocSet {
    private final int maxDoc;

    public AllDocSet(int maxDoc) {
        this.maxDoc = maxDoc;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public int length() {
        return this.maxDoc;
    }

    @Override
    public boolean get(int doc) {
        return doc < this.maxDoc;
    }

    @Override
    public long sizeInBytes() {
        return 4L;
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        return new AllDocIdSetIterator(this.maxDoc);
    }

    public static final class AllDocIdSetIterator
    extends DocIdSetIterator {
        private final int maxDoc;
        private int doc = -1;

        public AllDocIdSetIterator(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            if (++this.doc < this.maxDoc) {
                return this.doc;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) throws IOException {
            this.doc = target;
            if (this.doc < this.maxDoc) {
                return this.doc;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
    }
}

