/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.lucene.docset.DocSet;

public class FixedBitDocSet
extends DocSet {
    private final FixedBitSet set;

    public FixedBitDocSet(FixedBitSet set) {
        this.set = set;
    }

    public FixedBitDocSet(int numBits) {
        this.set = new FixedBitSet(numBits);
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public int length() {
        return this.set.length();
    }

    public FixedBitSet set() {
        return this.set;
    }

    @Override
    public boolean get(int doc) {
        return this.set.get(doc);
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        return this.set.iterator();
    }

    @Override
    public long sizeInBytes() {
        return this.set.getBits().length * 8 + RamUsage.NUM_BYTES_ARRAY_HEADER + 4;
    }
}

