/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterClause;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;

public class XBooleanFilter
extends Filter {
    ArrayList<Filter> shouldFilters = null;
    ArrayList<Filter> notFilters = null;
    ArrayList<Filter> mustFilters = null;

    private DocIdSet getDISI(ArrayList<Filter> filters, int index, IndexReader reader) throws IOException {
        DocIdSet docIdSet = filters.get(index).getDocIdSet(reader);
        if (docIdSet == DocIdSet.EMPTY_DOCIDSET || docIdSet == DocSet.EMPTY_DOC_SET) {
            return null;
        }
        return docIdSet;
    }

    public List<Filter> getShouldFilters() {
        return this.shouldFilters;
    }

    public List<Filter> getMustFilters() {
        return this.mustFilters;
    }

    public List<Filter> getNotFilters() {
        return this.notFilters;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        DocIdSet disi;
        int i;
        FixedBitSet res = null;
        if (this.mustFilters == null && this.notFilters == null && this.shouldFilters != null && this.shouldFilters.size() == 1) {
            return this.shouldFilters.get(0).getDocIdSet(reader);
        }
        if (this.shouldFilters == null && this.notFilters == null && this.mustFilters != null && this.mustFilters.size() == 1) {
            return this.mustFilters.get(0).getDocIdSet(reader);
        }
        if (this.shouldFilters != null) {
            for (i = 0; i < this.shouldFilters.size(); ++i) {
                disi = this.getDISI(this.shouldFilters, i, reader);
                if (disi == null) continue;
                if (res == null) {
                    res = new FixedBitSet(reader.maxDoc());
                }
                DocSets.or(res, disi);
            }
            if (res == null && !this.shouldFilters.isEmpty()) {
                return null;
            }
        }
        if (this.notFilters != null) {
            for (i = 0; i < this.notFilters.size(); ++i) {
                if (res == null) {
                    res = new FixedBitSet(reader.maxDoc());
                    res.set(0, reader.maxDoc());
                }
                if ((disi = this.getDISI(this.notFilters, i, reader)) == null) continue;
                DocSets.andNot(res, disi);
            }
        }
        if (this.mustFilters != null) {
            for (i = 0; i < this.mustFilters.size(); ++i) {
                disi = this.getDISI(this.mustFilters, i, reader);
                if (disi == null) {
                    return null;
                }
                if (res == null) {
                    res = new FixedBitSet(reader.maxDoc());
                    DocSets.or(res, disi);
                    continue;
                }
                DocSets.and(res, disi);
            }
        }
        return res;
    }

    public void add(FilterClause filterClause) {
        if (filterClause.getOccur().equals((Object)BooleanClause.Occur.MUST)) {
            if (this.mustFilters == null) {
                this.mustFilters = new ArrayList();
            }
            this.mustFilters.add(filterClause.getFilter());
        }
        if (filterClause.getOccur().equals((Object)BooleanClause.Occur.SHOULD)) {
            if (this.shouldFilters == null) {
                this.shouldFilters = new ArrayList();
            }
            this.shouldFilters.add(filterClause.getFilter());
        }
        if (filterClause.getOccur().equals((Object)BooleanClause.Occur.MUST_NOT)) {
            if (this.notFilters == null) {
                this.notFilters = new ArrayList();
            }
            this.notFilters.add(filterClause.getFilter());
        }
    }

    public void addMust(Filter filter) {
        if (this.mustFilters == null) {
            this.mustFilters = new ArrayList();
        }
        this.mustFilters.add(filter);
    }

    public void addShould(Filter filter) {
        if (this.shouldFilters == null) {
            this.shouldFilters = new ArrayList();
        }
        this.shouldFilters.add(filter);
    }

    public void addNot(Filter filter) {
        if (this.notFilters == null) {
            this.notFilters = new ArrayList();
        }
        this.notFilters.add(filter);
    }

    private boolean equalFilters(ArrayList<Filter> filters1, ArrayList<Filter> filters2) {
        return filters1 == filters2 || filters1 != null && filters1.equals(filters2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        XBooleanFilter other = (XBooleanFilter)obj;
        return this.equalFilters(this.notFilters, other.notFilters) && this.equalFilters(this.mustFilters, other.mustFilters) && this.equalFilters(this.shouldFilters, other.shouldFilters);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.mustFilters ? 0 : this.mustFilters.hashCode());
        hash = 31 * hash + (null == this.notFilters ? 0 : this.notFilters.hashCode());
        hash = 31 * hash + (null == this.shouldFilters ? 0 : this.shouldFilters.hashCode());
        return hash;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("BooleanFilter(");
        this.appendFilters(this.shouldFilters, "", buffer);
        this.appendFilters(this.mustFilters, "+", buffer);
        this.appendFilters(this.notFilters, "-", buffer);
        buffer.append(")");
        return buffer.toString();
    }

    private void appendFilters(ArrayList<Filter> filters, String occurString, StringBuilder buffer) {
        if (filters != null) {
            for (int i = 0; i < filters.size(); ++i) {
                buffer.append(' ');
                buffer.append(occurString);
                buffer.append(filters.get(i).toString());
            }
        }
    }
}

