/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.util.internal;

import java.util.ArrayList;

public final class ConversionUtil {
    private static final String[] INTEGERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};

    public static int toInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(String.valueOf(value));
    }

    public static boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        String s = String.valueOf(value);
        if (s.length() == 0) {
            return false;
        }
        try {
            return Integer.parseInt(s) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            switch (Character.toUpperCase(s.charAt(0))) {
                case 'T': 
                case 'Y': {
                    return true;
                }
            }
            return false;
        }
    }

    public static String[] toStringArray(Object value) {
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Iterable) {
            ArrayList<String> answer = new ArrayList<String>();
            for (Object v : (Iterable)value) {
                if (v == null) {
                    answer.add(null);
                    continue;
                }
                answer.add(String.valueOf(v));
            }
            return answer.toArray(new String[answer.size()]);
        }
        return String.valueOf(value).split("[, \\t\\n\\r\\f\\e\\a]");
    }

    public static String toString(int value) {
        if (value >= 0 && value < INTEGERS.length) {
            return INTEGERS[value];
        }
        return Integer.toString(value);
    }

    private ConversionUtil() {
    }
}

