/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.fabric;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.UUID;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.InitialStateDiscoveryListener;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.discovery.zen.publish.PublishClusterStateAction;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.fusesource.fabric.groups.ChangeListener;
import org.fusesource.fabric.groups.ClusteredSingleton;
import org.fusesource.fabric.groups.Group;
import org.fusesource.fabric.groups.NodeState;
import org.fusesource.fabric.groups.ZooKeeperGroupFactory;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;

public class FabricDiscovery
extends AbstractLifecycleComponent<Discovery>
implements Discovery,
DiscoveryNodesProvider,
ServiceTrackerCustomizer,
PublishClusterStateAction.NewClusterStateListener,
ChangeListener {
    protected final ClusterName clusterName;
    protected final ThreadPool threadPool;
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final NodeSettingsService nodeSettingsService;
    protected final DiscoveryNodeService discoveryNodeService;
    protected final BundleContext context;
    protected final ServiceTracker tracker;
    private DiscoveryNode localNode;
    private final CopyOnWriteArrayList<InitialStateDiscoveryListener> initialStateListeners = new CopyOnWriteArrayList();
    @Nullable
    private NodeService nodeService;
    private volatile DiscoveryNodes latestDiscoNodes;
    private final PublishClusterStateAction publishClusterState;
    private volatile Group group;
    private final ClusteredSingleton<ESNode> singleton;
    private final AtomicBoolean initialStateSent = new AtomicBoolean();
    private boolean joined;

    @Inject
    public FabricDiscovery(Settings settings, ClusterName clusterName, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, NodeSettingsService nodeSettingsService, DiscoveryNodeService discoveryNodeService) {
        super(settings);
        this.clusterName = clusterName;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.nodeSettingsService = nodeSettingsService;
        this.discoveryNodeService = discoveryNodeService;
        this.publishClusterState = new PublishClusterStateAction(settings, transportService, this, this);
        this.context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.tracker = new ServiceTracker(this.context, IZKClient.class.getName(), (ServiceTrackerCustomizer)this);
        this.singleton = new ClusteredSingleton(ESNode.class);
        this.singleton.add((ChangeListener)this);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        Map<String, String> nodeAttributes = this.discoveryNodeService.buildAttributes();
        String nodeId = UUID.randomBase64UUID();
        this.localNode = new DiscoveryNode(this.settings.get("name"), nodeId, this.transportService.boundAddress().publishAddress(), nodeAttributes);
        this.tracker.open();
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        try {
            this.singleton.leave();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.singleton.stop();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.group.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.tracker.close();
        this.initialStateSent.set(false);
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.publishClusterState.close();
    }

    @Override
    public DiscoveryNode localNode() {
        return this.localNode;
    }

    @Override
    public void addListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.add(listener);
    }

    @Override
    public void removeListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.remove(listener);
    }

    @Override
    public String nodeDescription() {
        return this.clusterName.value() + "/" + this.localNode.id();
    }

    @Override
    public void setNodeService(@Nullable NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void publish(ClusterState clusterState) {
        if (!this.singleton.isMaster()) {
            throw new ElasticSearchIllegalStateException("Shouldn't publish state when not master");
        }
        this.latestDiscoNodes = clusterState.nodes();
        this.publishClusterState.publish(clusterState);
    }

    @Override
    public DiscoveryNodes nodes() {
        DiscoveryNodes latestNodes = this.latestDiscoNodes;
        if (latestNodes != null) {
            return latestNodes;
        }
        return DiscoveryNodes.newNodesBuilder().put(this.localNode).localNodeId(this.localNode.id()).build();
    }

    @Override
    public NodeService nodeService() {
        return this.nodeService;
    }

    public Object addingService(ServiceReference reference) {
        IZKClient zk = (IZKClient)this.context.getService(reference);
        this.group = ZooKeeperGroupFactory.create((IZKClient)zk, (String)("/fabric/registry/clusters/elasticsearch/" + this.clusterName.value()));
        this.joined = false;
        this.singleton.start(this.group);
        this.joined = true;
        this.singleton.join((NodeState)new ESNode(this.clusterName.value(), this.localNode));
        return zk;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
        this.group.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(FabricDiscovery.class.getClassLoader());
            this.updateCluster();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private void updateCluster() {
        if (this.singleton.isMaster()) {
            this.clusterService.submitStateUpdateTask("fabric-discovery", new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ClusterState.Builder stateBuilder = ClusterState.newClusterStateBuilder().state(currentState);
                    DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.newNodesBuilder().localNodeId(FabricDiscovery.this.localNode.id()).masterNodeId(((ESNode)FabricDiscovery.this.singleton.master().get()).node().id()).put(((ESNode)FabricDiscovery.this.singleton.master().get()).node);
                    for (Object node : JavaConversions$.MODULE$.asJavaCollection((Iterable)FabricDiscovery.this.singleton.slaves())) {
                        nodesBuilder.put(((ESNode)node).node());
                    }
                    FabricDiscovery.this.latestDiscoNodes = nodesBuilder.build();
                    stateBuilder.nodes(FabricDiscovery.this.latestDiscoNodes);
                    for (Object node : FabricDiscovery.this.latestDiscoNodes) {
                        if (currentState.nodes().nodeExists(((DiscoveryNode)node).id())) continue;
                        FabricDiscovery.this.transportService.connectToNode((DiscoveryNode)node);
                    }
                    if (!FabricDiscovery.this.localNode().id().equals(currentState.nodes().masterNodeId())) {
                        ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(Discovery.NO_MASTER_BLOCK).build();
                        stateBuilder.blocks(clusterBlocks);
                    }
                    return stateBuilder.build();
                }

                @Override
                public void clusterStateProcessed(ClusterState clusterState) {
                    FabricDiscovery.this.sendInitialStateEventIfNeeded();
                }
            });
        } else if (this.joined && this.singleton.master().isDefined()) {
            DiscoveryNode masterNode = ((ESNode)this.singleton.master().get()).node();
            try {
                this.transportService.connectToNode(masterNode);
            }
            catch (Exception e) {
                this.logger.warn("failed to connect to master [{}], retrying...", e, masterNode);
            }
        }
    }

    public void connected() {
        this.changed();
    }

    public void disconnected() {
        this.changed();
    }

    @Override
    public void onNewClusterState(final ClusterState newState) {
        if (this.singleton.isMaster()) {
            this.logger.warn("master should not receive new cluster state from [{}]", newState.nodes().masterNode());
        } else if (newState.nodes().localNode() == null) {
            this.logger.warn("received a cluster state from [{}] and not part of the cluster, should not happen", newState.nodes().masterNode());
        } else {
            this.clusterService.submitStateUpdateTask("zen-disco-receive(from master [" + newState.nodes().masterNode() + "])", new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    FabricDiscovery.this.latestDiscoNodes = newState.nodes();
                    ClusterState.Builder builder = ClusterState.builder().state(newState);
                    if (newState.routingTable().version() == currentState.routingTable().version()) {
                        builder.routingTable(currentState.routingTable());
                    }
                    if (newState.metaData().version() == currentState.metaData().version()) {
                        builder.metaData(currentState.metaData());
                    } else {
                        MetaData.Builder metaDataBuilder = MetaData.builder().metaData(newState.metaData()).removeAllIndices();
                        for (IndexMetaData indexMetaData : newState.metaData()) {
                            IndexMetaData currentIndexMetaData = currentState.metaData().index(indexMetaData.index());
                            if (currentIndexMetaData == null || currentIndexMetaData.version() != indexMetaData.version()) {
                                metaDataBuilder.put(indexMetaData, false);
                                continue;
                            }
                            metaDataBuilder.put(currentIndexMetaData, false);
                        }
                        builder.metaData(metaDataBuilder);
                    }
                    return builder.build();
                }

                @Override
                public void clusterStateProcessed(ClusterState clusterState) {
                    FabricDiscovery.this.sendInitialStateEventIfNeeded();
                }
            });
        }
    }

    private void sendInitialStateEventIfNeeded() {
        if (this.initialStateSent.compareAndSet(false, true)) {
            for (InitialStateDiscoveryListener listener : this.initialStateListeners) {
                listener.initialStateProcessed();
            }
        }
    }

    static class NodeDeserializer
    extends JsonDeserializer<ESNode> {
        NodeDeserializer() {
        }

        public ESNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                Map map = (Map)jp.readValueAs(Map.class);
                String id = map.get("id").toString();
                DiscoveryNode node = (DiscoveryNode)Base64.decodeToObject(map.get("binary").toString(), 0, DiscoveryNode.class.getClassLoader());
                return new ESNode(id, node);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class NodeSerializer
    extends JsonSerializer<ESNode> {
        NodeSerializer() {
        }

        public void serialize(ESNode value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField("id", value.id());
            jgen.writeStringField("nodeName", value.node().name());
            jgen.writeStringField("nodeId", value.node().id());
            jgen.writeStringField("address", value.node().address().toString());
            jgen.writeStringField("version", value.node().version().toString());
            jgen.writeFieldName("attributes");
            jgen.writeStartObject();
            for (Map.Entry entry : value.node().attributes().entrySet()) {
                jgen.writeStringField((String)entry.getKey(), (String)entry.getValue());
            }
            jgen.writeEndObject();
            jgen.writeStringField("binary", Base64.encodeObject(value.node()));
            jgen.writeEndObject();
        }
    }

    @JsonSerialize(using=NodeSerializer.class)
    @JsonDeserialize(using=NodeDeserializer.class)
    static class ESNode
    implements NodeState {
        private final String id;
        private final DiscoveryNode node;

        ESNode(String id, DiscoveryNode node) {
            this.id = id;
            this.node = node;
        }

        public String id() {
            return this.id;
        }

        public DiscoveryNode node() {
            return this.node;
        }
    }
}

