/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.elect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class ElectMasterService
extends AbstractComponent {
    private final NodeComparator nodeComparator = new NodeComparator();
    private volatile int minimumMasterNodes;

    public ElectMasterService(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.minimumMasterNodes = settings.getAsInt("discovery.zen.minimum_master_nodes", -1);
        this.logger.debug("using minimum_master_nodes [{}]", this.minimumMasterNodes);
        nodeSettingsService.addListener(new ApplySettings());
    }

    public boolean hasEnoughMasterNodes(Iterable<DiscoveryNode> nodes) {
        if (this.minimumMasterNodes < 1) {
            return true;
        }
        int count = 0;
        for (DiscoveryNode node : nodes) {
            if (!node.masterNode()) continue;
            ++count;
        }
        return count >= this.minimumMasterNodes;
    }

    public DiscoveryNode[] nextPossibleMasters(Iterable<DiscoveryNode> nodes, int numberOfPossibleMasters) {
        List<DiscoveryNode> sortedNodes = this.sortedMasterNodes(nodes);
        if (sortedNodes == null) {
            return new DiscoveryNode[0];
        }
        ArrayList<DiscoveryNode> nextPossibleMasters = Lists.newArrayListWithCapacity(numberOfPossibleMasters);
        int counter = 0;
        for (DiscoveryNode nextPossibleMaster : sortedNodes) {
            if (++counter >= numberOfPossibleMasters) break;
            nextPossibleMasters.add(nextPossibleMaster);
        }
        return nextPossibleMasters.toArray(new DiscoveryNode[nextPossibleMasters.size()]);
    }

    public DiscoveryNode electMaster(Iterable<DiscoveryNode> nodes) {
        List<DiscoveryNode> sortedNodes = this.sortedMasterNodes(nodes);
        if (sortedNodes == null || sortedNodes.isEmpty()) {
            return null;
        }
        return sortedNodes.get(0);
    }

    private List<DiscoveryNode> sortedMasterNodes(Iterable<DiscoveryNode> nodes) {
        ArrayList<DiscoveryNode> possibleNodes = Lists.newArrayList(nodes);
        if (possibleNodes.isEmpty()) {
            return null;
        }
        Iterator it = possibleNodes.iterator();
        while (it.hasNext()) {
            DiscoveryNode node = (DiscoveryNode)it.next();
            if (node.masterNode()) continue;
            it.remove();
        }
        Collections.sort(possibleNodes, this.nodeComparator);
        return possibleNodes;
    }

    static {
        MetaData.addDynamicSettings("discovery.zen.minimum_master_nodes");
    }

    private static class NodeComparator
    implements Comparator<DiscoveryNode> {
        private NodeComparator() {
        }

        @Override
        public int compare(DiscoveryNode o1, DiscoveryNode o2) {
            return o1.id().compareTo(o2.id());
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            int minimumMasterNodes = settings.getAsInt("discovery.zen.minimum_master_nodes", ElectMasterService.this.minimumMasterNodes);
            if (minimumMasterNodes != ElectMasterService.this.minimumMasterNodes) {
                ElectMasterService.this.logger.info("updating [discovery.zen.minimum_master_nodes] from [{}] to [{}]", ElectMasterService.this.minimumMasterNodes, minimumMasterNodes);
                ElectMasterService.this.minimumMasterNodes = minimumMasterNodes;
            }
        }
    }
}

