/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataStateIndexService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class GatewayService
extends AbstractLifecycleComponent<GatewayService>
implements ClusterStateListener {
    public static final ClusterBlock STATE_NOT_RECOVERED_BLOCK = new ClusterBlock(1, "state not recovered / initialized", true, true, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    private final Gateway gateway;
    private final ThreadPool threadPool;
    private final AllocationService allocationService;
    private final ClusterService clusterService;
    private final DiscoveryService discoveryService;
    private final TimeValue recoverAfterTime;
    private final int recoverAfterNodes;
    private final int expectedNodes;
    private final int recoverAfterDataNodes;
    private final int expectedDataNodes;
    private final int recoverAfterMasterNodes;
    private final int expectedMasterNodes;
    private final AtomicBoolean recovered = new AtomicBoolean();
    private final AtomicBoolean scheduledRecovery = new AtomicBoolean();

    @Inject
    public GatewayService(Settings settings, Gateway gateway, AllocationService allocationService, ClusterService clusterService, DiscoveryService discoveryService, ThreadPool threadPool) {
        super(settings);
        this.gateway = gateway;
        this.allocationService = allocationService;
        this.clusterService = clusterService;
        this.discoveryService = discoveryService;
        this.threadPool = threadPool;
        this.recoverAfterTime = this.componentSettings.getAsTime("recover_after_time", null);
        this.recoverAfterNodes = this.componentSettings.getAsInt("recover_after_nodes", -1);
        this.expectedNodes = this.componentSettings.getAsInt("expected_nodes", -1);
        this.recoverAfterDataNodes = this.componentSettings.getAsInt("recover_after_data_nodes", -1);
        this.expectedDataNodes = this.componentSettings.getAsInt("expected_data_nodes", -1);
        this.recoverAfterMasterNodes = this.componentSettings.getAsInt("recover_after_master_nodes", settings.getAsInt("discovery.zen.minimum_master_nodes", -1));
        this.expectedMasterNodes = this.componentSettings.getAsInt("expected_master_nodes", -1);
        this.clusterService.addInitialStateBlock(STATE_NOT_RECOVERED_BLOCK);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.gateway.start();
        if (this.discoveryService.initialStateReceived()) {
            ClusterState clusterState = this.clusterService.state();
            DiscoveryNodes nodes = clusterState.nodes();
            if (clusterState.nodes().localNodeMaster() && clusterState.blocks().hasGlobalBlock(STATE_NOT_RECOVERED_BLOCK)) {
                if (clusterState.blocks().hasGlobalBlock(Discovery.NO_MASTER_BLOCK)) {
                    this.logger.debug("not recovering from gateway, no master elected yet", new Object[0]);
                } else if (this.recoverAfterNodes != -1 && nodes.masterAndDataNodes().size() < this.recoverAfterNodes) {
                    this.logger.debug("not recovering from gateway, nodes_size (data+master) [" + nodes.masterAndDataNodes().size() + "] < recover_after_nodes [" + this.recoverAfterNodes + "]", new Object[0]);
                } else if (this.recoverAfterDataNodes != -1 && nodes.dataNodes().size() < this.recoverAfterDataNodes) {
                    this.logger.debug("not recovering from gateway, nodes_size (data) [" + nodes.dataNodes().size() + "] < recover_after_data_nodes [" + this.recoverAfterDataNodes + "]", new Object[0]);
                } else if (this.recoverAfterMasterNodes != -1 && nodes.masterNodes().size() < this.recoverAfterMasterNodes) {
                    this.logger.debug("not recovering from gateway, nodes_size (master) [" + nodes.masterNodes().size() + "] < recover_after_master_nodes [" + this.recoverAfterMasterNodes + "]", new Object[0]);
                } else {
                    boolean ignoreRecoverAfterTime;
                    if (this.expectedNodes == -1 && this.expectedMasterNodes == -1 && this.expectedDataNodes == -1) {
                        ignoreRecoverAfterTime = false;
                    } else {
                        ignoreRecoverAfterTime = true;
                        if (this.expectedNodes != -1 && nodes.masterAndDataNodes().size() < this.expectedNodes) {
                            ignoreRecoverAfterTime = false;
                        }
                        if (this.expectedMasterNodes != -1 && nodes.masterNodes().size() < this.expectedMasterNodes) {
                            ignoreRecoverAfterTime = false;
                        }
                        if (this.expectedDataNodes != -1 && nodes.dataNodes().size() < this.expectedDataNodes) {
                            ignoreRecoverAfterTime = false;
                        }
                    }
                    this.performStateRecovery(ignoreRecoverAfterTime);
                }
            }
        } else {
            this.logger.debug("can't wait on start for (possibly) reading state from gateway, will do it asynchronously", new Object[0]);
        }
        this.clusterService.addLast(this);
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.clusterService.remove(this);
        this.gateway.stop();
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.gateway.close();
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (this.lifecycle.stoppedOrClosed()) {
            return;
        }
        if (event.state().blocks().hasGlobalBlock(Discovery.NO_MASTER_BLOCK)) {
            this.recovered.set(false);
            this.scheduledRecovery.set(false);
        }
        if (event.localNodeMaster() && event.state().blocks().hasGlobalBlock(STATE_NOT_RECOVERED_BLOCK)) {
            ClusterState clusterState = event.state();
            DiscoveryNodes nodes = clusterState.nodes();
            if (event.state().blocks().hasGlobalBlock(Discovery.NO_MASTER_BLOCK)) {
                this.logger.debug("not recovering from gateway, no master elected yet", new Object[0]);
            } else if (this.recoverAfterNodes != -1 && nodes.masterAndDataNodes().size() < this.recoverAfterNodes) {
                this.logger.debug("not recovering from gateway, nodes_size (data+master) [" + nodes.masterAndDataNodes().size() + "] < recover_after_nodes [" + this.recoverAfterNodes + "]", new Object[0]);
            } else if (this.recoverAfterDataNodes != -1 && nodes.dataNodes().size() < this.recoverAfterDataNodes) {
                this.logger.debug("not recovering from gateway, nodes_size (data) [" + nodes.dataNodes().size() + "] < recover_after_data_nodes [" + this.recoverAfterDataNodes + "]", new Object[0]);
            } else if (this.recoverAfterMasterNodes != -1 && nodes.masterNodes().size() < this.recoverAfterMasterNodes) {
                this.logger.debug("not recovering from gateway, nodes_size (master) [" + nodes.masterNodes().size() + "] < recover_after_master_nodes [" + this.recoverAfterMasterNodes + "]", new Object[0]);
            } else {
                boolean ignoreRecoverAfterTime;
                if (this.expectedNodes == -1 && this.expectedMasterNodes == -1 && this.expectedDataNodes == -1) {
                    ignoreRecoverAfterTime = false;
                } else {
                    ignoreRecoverAfterTime = true;
                    if (this.expectedNodes != -1 && nodes.masterAndDataNodes().size() < this.expectedNodes) {
                        ignoreRecoverAfterTime = false;
                    }
                    if (this.expectedMasterNodes != -1 && nodes.masterNodes().size() < this.expectedMasterNodes) {
                        ignoreRecoverAfterTime = false;
                    }
                    if (this.expectedDataNodes != -1 && nodes.dataNodes().size() < this.expectedDataNodes) {
                        ignoreRecoverAfterTime = false;
                    }
                }
                final boolean fIgnoreRecoverAfterTime = ignoreRecoverAfterTime;
                this.threadPool.generic().execute(new Runnable(){

                    @Override
                    public void run() {
                        GatewayService.this.performStateRecovery(fIgnoreRecoverAfterTime);
                    }
                });
            }
        }
    }

    private void performStateRecovery(boolean ignoreRecoverAfterTime) {
        final GatewayRecoveryListener recoveryListener = new GatewayRecoveryListener(new CountDownLatch(1));
        if (!ignoreRecoverAfterTime && this.recoverAfterTime != null) {
            if (this.scheduledRecovery.compareAndSet(false, true)) {
                this.logger.debug("delaying initial state recovery for [{}]", this.recoverAfterTime);
                this.threadPool.schedule(this.recoverAfterTime, "generic", new Runnable(){

                    @Override
                    public void run() {
                        if (GatewayService.this.recovered.compareAndSet(false, true)) {
                            GatewayService.this.gateway.performStateRecovery(recoveryListener);
                        }
                    }
                });
            }
        } else if (this.recovered.compareAndSet(false, true)) {
            this.gateway.performStateRecovery(recoveryListener);
        }
    }

    class GatewayRecoveryListener
    implements Gateway.GatewayStateRecoveredListener {
        private final CountDownLatch latch;

        GatewayRecoveryListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void onSuccess(final ClusterState recoveredState) {
            GatewayService.this.clusterService.submitStateUpdateTask("local-gateway-elected-state", new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    assert (currentState.metaData().indices().isEmpty());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).blocks(recoveredState.blocks()).removeGlobalBlock(STATE_NOT_RECOVERED_BLOCK);
                    MetaData.Builder metaDataBuilder = MetaData.newMetaDataBuilder().metaData(recoveredState.metaData());
                    if (recoveredState.metaData().settings().getAsBoolean("cluster.blocks.read_only", false).booleanValue() || currentState.metaData().settings().getAsBoolean("cluster.blocks.read_only", false).booleanValue()) {
                        blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
                    }
                    for (IndexMetaData indexMetaData : recoveredState.metaData()) {
                        metaDataBuilder.put(indexMetaData, false);
                        if (indexMetaData.state() == IndexMetaData.State.CLOSE) {
                            blocks.addIndexBlock(indexMetaData.index(), MetaDataStateIndexService.INDEX_CLOSED_BLOCK);
                        }
                        if (indexMetaData.settings().getAsBoolean("index.blocks.read_only", false).booleanValue()) {
                            blocks.addIndexBlock(indexMetaData.index(), IndexMetaData.INDEX_READ_ONLY_BLOCK);
                        }
                        if (indexMetaData.settings().getAsBoolean("index.blocks.read", false).booleanValue()) {
                            blocks.addIndexBlock(indexMetaData.index(), IndexMetaData.INDEX_READ_BLOCK);
                        }
                        if (indexMetaData.settings().getAsBoolean("index.blocks.write", false).booleanValue()) {
                            blocks.addIndexBlock(indexMetaData.index(), IndexMetaData.INDEX_WRITE_BLOCK);
                        }
                        if (!indexMetaData.settings().getAsBoolean("index.blocks.metadata", false).booleanValue()) continue;
                        blocks.addIndexBlock(indexMetaData.index(), IndexMetaData.INDEX_METADATA_BLOCK);
                    }
                    ClusterState updatedState = ClusterState.newClusterStateBuilder().state(currentState).blocks(blocks).metaData(metaDataBuilder).build();
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder().routingTable(updatedState.routingTable());
                    for (IndexMetaData indexMetaData : updatedState.metaData().indices().values()) {
                        if (indexMetaData.state() != IndexMetaData.State.OPEN) continue;
                        IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.index()).initializeEmpty(updatedState.metaData().index(indexMetaData.index()), false);
                        routingTableBuilder.add(indexRoutingBuilder);
                    }
                    routingTableBuilder.version(0L);
                    RoutingAllocation.Result routingResult = GatewayService.this.allocationService.reroute(ClusterState.newClusterStateBuilder().state(updatedState).routingTable(routingTableBuilder).build());
                    return ClusterState.newClusterStateBuilder().state(updatedState).routingResult(routingResult).build();
                }

                @Override
                public void clusterStateProcessed(ClusterState clusterState) {
                    GatewayService.this.logger.info("recovered [{}] indices into cluster_state", clusterState.metaData().indices().size());
                    GatewayRecoveryListener.this.latch.countDown();
                }
            });
        }

        @Override
        public void onFailure(String message) {
            GatewayService.this.recovered.set(false);
            GatewayService.this.scheduledRecovery.set(false);
            GatewayService.this.logger.info("metadata state not restored, reason: {}", message);
        }
    }
}

