/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.ArrayList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class CustomAnalyzerProvider
extends AbstractIndexAnalyzerProvider<CustomAnalyzer> {
    private final Settings analyzerSettings;
    private CustomAnalyzer customAnalyzer;

    @Inject
    public CustomAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.analyzerSettings = settings;
    }

    public void build(AnalysisService analysisService) {
        String[] tokenFilterNames;
        String[] charFilterNames;
        String tokenizerName = this.analyzerSettings.get("tokenizer");
        if (tokenizerName == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] must be configured with a tokenizer");
        }
        TokenizerFactory tokenizer = analysisService.tokenizer(tokenizerName);
        if (tokenizer == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find tokenizer under name [" + tokenizerName + "]");
        }
        ArrayList<CharFilterFactory> charFilters = Lists.newArrayList();
        for (String charFilterName : charFilterNames = this.analyzerSettings.getAsArray("char_filter")) {
            CharFilterFactory charFilter = analysisService.charFilter(charFilterName);
            if (charFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find char_filter under name [" + charFilterName + "]");
            }
            charFilters.add(charFilter);
        }
        ArrayList<TokenFilterFactory> tokenFilters = Lists.newArrayList();
        for (String tokenFilterName : tokenFilterNames = this.analyzerSettings.getAsArray("filter")) {
            TokenFilterFactory tokenFilter = analysisService.tokenFilter(tokenFilterName);
            if (tokenFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find filter under name [" + tokenFilterName + "]");
            }
            tokenFilters.add(tokenFilter);
        }
        int positionOffsetGap = this.analyzerSettings.getAsInt("position_offset_gap", 0);
        int offsetGap = this.analyzerSettings.getAsInt("offset_gap", -1);
        this.customAnalyzer = new CustomAnalyzer(tokenizer, charFilters.toArray(new CharFilterFactory[charFilters.size()]), tokenFilters.toArray(new TokenFilterFactory[tokenFilters.size()]), positionOffsetGap, offsetGap);
    }

    @Override
    public CustomAnalyzer get() {
        return this.customAnalyzer;
    }
}

