/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.floats;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.floats.FloatFieldData;
import org.elasticsearch.index.field.data.floats.FloatFieldDataComparator;
import org.elasticsearch.index.field.data.floats.FloatFieldDataMissingComparator;

public class FloatFieldDataType
implements FieldDataType<FloatFieldData> {
    @Override
    public FieldDataType.ExtendedFieldComparatorSource newFieldComparatorSource(final FieldDataCache cache, final String missing) {
        if (missing == null) {
            return new FieldDataType.ExtendedFieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new FloatFieldDataComparator(numHits, fieldname, cache);
                }

                @Override
                public int reducedType() {
                    return 5;
                }
            };
        }
        if (missing.equals("_last")) {
            return new FieldDataType.ExtendedFieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new FloatFieldDataMissingComparator(numHits, fieldname, cache, reversed ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
                }

                @Override
                public int reducedType() {
                    return 5;
                }
            };
        }
        if (missing.equals("_first")) {
            return new FieldDataType.ExtendedFieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new FloatFieldDataMissingComparator(numHits, fieldname, cache, reversed ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
                }

                @Override
                public int reducedType() {
                    return 5;
                }
            };
        }
        return new FieldDataType.ExtendedFieldComparatorSource(){

            public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                return new FloatFieldDataMissingComparator(numHits, fieldname, cache, Float.parseFloat(missing));
            }

            @Override
            public int reducedType() {
                return 5;
            }
        };
    }

    @Override
    public FloatFieldData load(IndexReader reader, String fieldName) throws IOException {
        return FloatFieldData.load(reader, fieldName);
    }
}

