/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class GetField
implements Streamable,
Iterable<Object> {
    private String name;
    private List<Object> values;

    private GetField() {
    }

    public GetField(String name, List<Object> values) {
        this.name = name;
        this.values = values;
    }

    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Object value() {
        if (this.values != null && !this.values.isEmpty()) {
            return this.values.get(0);
        }
        return null;
    }

    public Object getValue() {
        return this.value();
    }

    public List<Object> values() {
        return this.values;
    }

    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public static GetField readGetField(StreamInput in) throws IOException {
        GetField result = new GetField();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        int size = in.readVInt();
        this.values = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            this.values.add(in.readGenericValue());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeVInt(this.values.size());
        for (Object obj : this.values) {
            out.writeGenericValue(obj);
        }
    }
}

