/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PublicTermsFilter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;

public class ParentFieldMapper
extends AbstractFieldMapper<Uid>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_parent";
    public static final String CONTENT_TYPE = "_parent";
    private final String type;

    protected ParentFieldMapper(String name, String indexName, String type) {
        super(new FieldMapper.Names(name, indexName, indexName, name), Defaults.INDEX, Field.Store.YES, Defaults.TERM_VECTOR, 1.0f, true, true, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        this.type = type;
    }

    public String type() {
        return this.type;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        this.parse(context);
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        if (context.parser().currentName() != null && context.parser().currentName().equals("_parent")) {
            String parentId = context.parser().text();
            context.sourceToParse().parent(parentId);
            return new Field(this.names.indexName(), Uid.createUid(context.stringBuilder(), this.type, parentId), this.store, this.index);
        }
        String parsedParentId = context.doc().get("_parent");
        if (context.sourceToParse().parent() != null) {
            String parentId = context.sourceToParse().parent();
            if (parsedParentId == null) {
                if (parentId == null) {
                    throw new MapperParsingException("No parent id provided, not within the document, and not externally");
                }
                return new Field(this.names.indexName(), Uid.createUid(context.stringBuilder(), this.type, parentId), this.store, this.index);
            }
            if (parentId != null && !parsedParentId.equals(Uid.createUid(context.stringBuilder(), this.type, parentId))) {
                throw new MapperParsingException("Parent id mismatch, document value is [" + Uid.createUid(parsedParentId).id() + "], while external value is [" + parentId + "]");
            }
        }
        return null;
    }

    @Override
    public Uid value(Fieldable field) {
        return Uid.createUid(field.stringValue());
    }

    @Override
    public Uid valueFromString(String value) {
        return Uid.createUid(value);
    }

    @Override
    public String valueAsString(Fieldable field) {
        return field.stringValue();
    }

    @Override
    public Object valueForSearch(Fieldable field) {
        String fieldValue = field.stringValue();
        if (fieldValue == null) {
            return null;
        }
        int index = fieldValue.indexOf(35);
        if (index == -1) {
            return fieldValue;
        }
        return fieldValue.substring(index + 1);
    }

    @Override
    public String indexedValue(String value) {
        if (value.indexOf(35) == -1) {
            return Uid.createUid(this.type, value);
        }
        return value;
    }

    @Override
    public Query fieldQuery(String value, @Nullable QueryParseContext context) {
        if (context == null) {
            return super.fieldQuery(value, context);
        }
        return new ConstantScoreQuery(this.fieldFilter(value, context));
    }

    @Override
    public Filter fieldFilter(String value, @Nullable QueryParseContext context) {
        if (context == null) {
            return super.fieldFilter(value, context);
        }
        PublicTermsFilter filter = new PublicTermsFilter();
        for (String type : context.mapperService().types()) {
            filter.addTerm(this.names.createIndexNameTerm(Uid.createUid(type, value)));
        }
        return filter;
    }

    @Override
    public boolean useFieldQueryWithQueryString() {
        return true;
    }

    public Term term(String type, String id) {
        return this.term(Uid.createUid(type, id));
    }

    public Term term(String uid) {
        return this.names().createIndexNameTerm(uid);
    }

    @Override
    protected String contentType() {
        return "_parent";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("_parent");
        builder.field("type", this.type);
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("type")) continue;
                builder.type(fieldNode.toString());
            }
            return builder;
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, ParentFieldMapper> {
        protected String indexName;
        private String type;

        public Builder() {
            super("_parent");
            this.indexName = this.name;
        }

        public Builder type(String type) {
            this.type = type;
            return (Builder)this.builder;
        }

        @Override
        public ParentFieldMapper build(Mapper.BuilderContext context) {
            if (this.type == null) {
                throw new MapperParsingException("Parent mapping must contain the parent type");
            }
            return new ParentFieldMapper(this.name, this.indexName, this.type);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_parent";
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final boolean OMIT_NORMS = true;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = true;
    }
}

