/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.compress.lzf.LZF;
import org.elasticsearch.common.compress.lzf.LZFDecoder;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.LZFStreamInput;
import org.elasticsearch.common.io.stream.LZFStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.document.ResetFieldSelector;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldSelector;

public class SourceFieldMapper
extends AbstractFieldMapper<byte[]>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_source";
    public static final String CONTENT_TYPE = "_source";
    private final boolean enabled;
    private Boolean compress;
    private long compressThreshold;
    private String[] includes;
    private String[] excludes;
    private String format;
    private XContentType formatContentType;

    public SourceFieldMapper() {
        this("_source", true, Defaults.FORMAT, null, -1L, Defaults.INCLUDES, Defaults.EXCLUDES);
    }

    protected SourceFieldMapper(String name, boolean enabled, String format, Boolean compress, long compressThreshold, String[] includes, String[] excludes) {
        super(new FieldMapper.Names(name, name, name, name), Defaults.INDEX, Defaults.STORE, Defaults.TERM_VECTOR, 1.0f, true, true, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        this.enabled = enabled;
        this.compress = compress;
        this.compressThreshold = compressThreshold;
        this.includes = includes;
        this.excludes = excludes;
        this.format = format;
        this.formatContentType = format == null ? null : XContentType.fromRestContentType(format);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public ResetFieldSelector fieldSelector() {
        return SourceFieldSelector.INSTANCE;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        boolean filtered;
        if (!this.enabled) {
            return null;
        }
        if (this.store == Field.Store.NO) {
            return null;
        }
        if (context.flyweight()) {
            return null;
        }
        byte[] data = context.source();
        int dataOffset = context.sourceOffset();
        int dataLength = context.sourceLength();
        boolean bl = filtered = this.includes.length > 0 || this.excludes.length > 0;
        if (filtered) {
            Tuple<XContentType, Map<String, Object>> mapTuple = XContentHelper.convertToMap(data, dataOffset, dataLength, true);
            Map<String, Object> filteredSource = XContentMapValues.filter(mapTuple.v2(), this.includes, this.excludes);
            CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
            StreamOutput streamOutput = this.compress != null && this.compress != false && (this.compressThreshold == -1L || (long)dataLength > this.compressThreshold) ? cachedEntry.cachedLZFBytes() : cachedEntry.cachedBytes();
            XContentType contentType = this.formatContentType;
            if (contentType == null) {
                contentType = mapTuple.v1();
            }
            XContentBuilder builder = XContentFactory.contentBuilder(contentType, streamOutput).map(filteredSource);
            builder.close();
            data = cachedEntry.bytes().copiedByteArray();
            dataOffset = 0;
            dataLength = data.length;
            CachedStreamOutput.pushEntry(cachedEntry);
        } else if (this.compress != null && this.compress.booleanValue() && !LZF.isCompressed(data, dataOffset, dataLength)) {
            if (this.compressThreshold == -1L || (long)dataLength > this.compressThreshold) {
                CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
                try {
                    XContentType contentType = XContentFactory.xContentType(data, dataOffset, dataLength);
                    if (this.formatContentType != null && this.formatContentType != contentType) {
                        XContentBuilder builder = XContentFactory.contentBuilder(this.formatContentType, cachedEntry.cachedLZFBytes());
                        builder.copyCurrentStructure(XContentFactory.xContent(contentType).createParser(data, dataOffset, dataLength));
                        builder.close();
                    } else {
                        LZFStreamOutput streamOutput = cachedEntry.cachedLZFBytes();
                        streamOutput.writeBytes(data, dataOffset, dataLength);
                        streamOutput.flush();
                    }
                    data = cachedEntry.bytes().copiedByteArray();
                    dataOffset = 0;
                    dataLength = data.length;
                    context.source(data, dataOffset, dataLength);
                }
                finally {
                    CachedStreamOutput.pushEntry(cachedEntry);
                }
            }
        } else if (this.formatContentType != null) {
            if (LZF.isCompressed(data, dataOffset, dataLength)) {
                BytesStreamInput siBytes = new BytesStreamInput(data, dataOffset, dataLength, false);
                LZFStreamInput siLzf = CachedStreamInput.cachedLzf(siBytes);
                XContentType contentType = XContentFactory.xContentType(siLzf);
                siLzf.resetToBufferStart();
                if (contentType != this.formatContentType) {
                    CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
                    try {
                        LZFStreamOutput streamOutput = cachedEntry.cachedLZFBytes();
                        XContentBuilder builder = XContentFactory.contentBuilder(this.formatContentType, streamOutput);
                        builder.copyCurrentStructure(XContentFactory.xContent(contentType).createParser(siLzf));
                        builder.close();
                        data = cachedEntry.bytes().copiedByteArray();
                        dataOffset = 0;
                        dataLength = data.length;
                        context.source(data, dataOffset, dataLength);
                    }
                    finally {
                        CachedStreamOutput.pushEntry(cachedEntry);
                    }
                }
            } else {
                XContentType contentType = XContentFactory.xContentType(data, dataOffset, dataLength);
                if (contentType != this.formatContentType) {
                    CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
                    try {
                        XContentBuilder builder = XContentFactory.contentBuilder(this.formatContentType, cachedEntry.cachedBytes());
                        builder.copyCurrentStructure(XContentFactory.xContent(contentType).createParser(data, dataOffset, dataLength));
                        builder.close();
                        data = cachedEntry.bytes().copiedByteArray();
                        dataOffset = 0;
                        dataLength = data.length;
                        context.source(data, dataOffset, dataLength);
                    }
                    finally {
                        CachedStreamOutput.pushEntry(cachedEntry);
                    }
                }
            }
        }
        return new Field(this.names().indexName(), data, dataOffset, dataLength);
    }

    public byte[] value(Document document) {
        Fieldable field = document.getFieldable(this.names.indexName());
        return field == null ? null : this.value(field);
    }

    public byte[] nativeValue(Fieldable field) {
        return field.getBinaryValue();
    }

    @Override
    public byte[] value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value == null) {
            return value;
        }
        if (LZF.isCompressed(value)) {
            try {
                return LZFDecoder.decode(value);
            }
            catch (IOException e) {
                throw new ElasticSearchParseException("failed to decompress source", e);
            }
        }
        return value;
    }

    @Override
    public byte[] valueFromString(String value) {
        return null;
    }

    @Override
    public String valueAsString(Fieldable field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String indexedValue(String value) {
        return value;
    }

    @Override
    protected String contentType() {
        return "_source";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.enabled && this.compress == null && this.compressThreshold == -1L && this.includes.length == 0 && this.excludes.length == 0) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (!this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (!Objects.equal(this.format, Defaults.FORMAT)) {
            builder.field("format", this.format);
        }
        if (this.compress != null) {
            builder.field("compress", (Object)this.compress);
        }
        if (this.compressThreshold != -1L) {
            builder.field("compress_threshold", new ByteSizeValue(this.compressThreshold).toString());
        }
        if (this.includes.length > 0) {
            builder.field("includes", this.includes);
        }
        if (this.excludes.length > 0) {
            builder.field("excludes", this.excludes);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        SourceFieldMapper sourceMergeWith = (SourceFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate()) {
            if (sourceMergeWith.compress != null) {
                this.compress = sourceMergeWith.compress;
            }
            if (sourceMergeWith.compressThreshold != -1L) {
                this.compressThreshold = sourceMergeWith.compressThreshold;
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.source();
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                int i;
                List values;
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("compress") && fieldNode != null) {
                    builder.compress(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("compress_threshold") && fieldNode != null) {
                    if (fieldNode instanceof Number) {
                        builder.compressThreshold(((Number)fieldNode).longValue());
                        builder.compress(true);
                        continue;
                    }
                    builder.compressThreshold(ByteSizeValue.parseBytesSizeValue(fieldNode.toString()).bytes());
                    builder.compress(true);
                    continue;
                }
                if ("format".equals(fieldName)) {
                    builder.format(XContentMapValues.nodeStringValue(fieldNode, null));
                    continue;
                }
                if (fieldName.equals("includes")) {
                    values = (List)fieldNode;
                    String[] includes = new String[values.size()];
                    for (i = 0; i < includes.length; ++i) {
                        includes[i] = values.get(i).toString();
                    }
                    builder.includes(includes);
                    continue;
                }
                if (!fieldName.equals("excludes")) continue;
                values = (List)fieldNode;
                String[] excludes = new String[values.size()];
                for (i = 0; i < excludes.length; ++i) {
                    excludes[i] = values.get(i).toString();
                }
                builder.excludes(excludes);
            }
            return builder;
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, SourceFieldMapper> {
        private boolean enabled = true;
        private long compressThreshold = -1L;
        private Boolean compress = null;
        private String format = Defaults.FORMAT;
        private String[] includes = Defaults.INCLUDES;
        private String[] excludes = Defaults.EXCLUDES;

        public Builder() {
            super("_source");
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder compressThreshold(long compressThreshold) {
            this.compressThreshold = compressThreshold;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder includes(String[] includes) {
            this.includes = includes;
            return this;
        }

        public Builder excludes(String[] excludes) {
            this.excludes = excludes;
            return this;
        }

        @Override
        public SourceFieldMapper build(Mapper.BuilderContext context) {
            return new SourceFieldMapper(this.name, this.enabled, this.format, this.compress, this.compressThreshold, this.includes, this.excludes);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_source";
        public static final boolean ENABLED = true;
        public static final long COMPRESS_THRESHOLD = -1L;
        public static final String FORMAT = null;
        public static final Field.Index INDEX = Field.Index.NO;
        public static final Field.Store STORE = Field.Store.YES;
        public static final boolean OMIT_NORMS = true;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = true;
        public static final String[] INCLUDES = Strings.EMPTY_ARRAY;
        public static final String[] EXCLUDES = Strings.EMPTY_ARRAY;
    }
}

