/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.TieredMergePolicy;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.merge.policy.EnableMergePolicy;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.store.Store;

public class TieredMergePolicyProvider
extends AbstractIndexShardComponent
implements MergePolicyProvider<TieredMergePolicy> {
    private final IndexSettingsService indexSettingsService;
    private final Set<CustomTieredMergePolicyProvider> policies = new CopyOnWriteArraySet<CustomTieredMergePolicyProvider>();
    private volatile boolean compoundFormat;
    private volatile double forceMergeDeletesPctAllowed;
    private volatile ByteSizeValue floorSegment;
    private volatile int maxMergeAtOnce;
    private volatile int maxMergeAtOnceExplicit;
    private volatile ByteSizeValue maxMergedSegment;
    private volatile double segmentsPerTier;
    private volatile double reclaimDeletesWeight;
    private boolean asyncMerge;
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public TieredMergePolicyProvider(Store store, IndexSettingsService indexSettingsService) {
        super(store.shardId(), store.indexSettings());
        this.indexSettingsService = indexSettingsService;
        this.compoundFormat = this.indexSettings.getAsBoolean("index.compound_format", store.suggestUseCompoundFile());
        this.asyncMerge = this.indexSettings.getAsBoolean("index.merge.async", true);
        this.forceMergeDeletesPctAllowed = this.componentSettings.getAsDouble("expunge_deletes_allowed", 10.0);
        this.floorSegment = this.componentSettings.getAsBytesSize("floor_segment", new ByteSizeValue(2L, ByteSizeUnit.MB));
        this.maxMergeAtOnce = this.componentSettings.getAsInt("max_merge_at_once", 10);
        this.maxMergeAtOnceExplicit = this.componentSettings.getAsInt("max_merge_at_once_explicit", 30);
        this.maxMergedSegment = this.componentSettings.getAsBytesSize("max_merged_segment", this.componentSettings.getAsBytesSize("max_merge_segment", new ByteSizeValue(5L, ByteSizeUnit.GB)));
        this.segmentsPerTier = this.componentSettings.getAsDouble("segments_per_tier", 9.2);
        this.reclaimDeletesWeight = this.componentSettings.getAsDouble("reclaim_deletes_weight", 2.0);
        this.fixSettingsIfNeeded();
        this.logger.debug("using [tiered] merge policy with expunge_deletes_allowed[{}], floor_segment[{}], max_merge_at_once[{}], max_merge_at_once_explicit[{}], max_merged_segment[{}], segments_per_tier[{}], reclaim_deletes_weight[{}], async_merge[{}]", this.forceMergeDeletesPctAllowed, this.floorSegment, this.maxMergeAtOnce, this.maxMergeAtOnceExplicit, this.maxMergedSegment, this.segmentsPerTier, this.reclaimDeletesWeight, this.asyncMerge);
        indexSettingsService.addListener(this.applySettings);
    }

    private void fixSettingsIfNeeded() {
        if (!(this.segmentsPerTier >= (double)this.maxMergeAtOnce)) {
            int newMaxMergeAtOnce = (int)this.segmentsPerTier;
            this.logger.debug("[tiered] merge policy changing max_merge_at_once from [{}] to [{}] because segments_per_tier [{}] has to be higher or equal to it", this.maxMergeAtOnce, newMaxMergeAtOnce, this.segmentsPerTier);
            this.maxMergeAtOnce = newMaxMergeAtOnce;
        }
    }

    @Override
    public TieredMergePolicy newMergePolicy() {
        CustomTieredMergePolicyProvider mergePolicy = this.asyncMerge ? new EnableMergeTieredMergePolicyProvider(this) : new CustomTieredMergePolicyProvider(this);
        mergePolicy.setUseCompoundFile(this.compoundFormat);
        mergePolicy.setForceMergeDeletesPctAllowed(this.forceMergeDeletesPctAllowed);
        mergePolicy.setFloorSegmentMB(this.floorSegment.mbFrac());
        mergePolicy.setMaxMergeAtOnce(this.maxMergeAtOnce);
        mergePolicy.setMaxMergeAtOnceExplicit(this.maxMergeAtOnceExplicit);
        mergePolicy.setMaxMergedSegmentMB(this.maxMergedSegment.mbFrac());
        mergePolicy.setSegmentsPerTier(this.segmentsPerTier);
        mergePolicy.setReclaimDeletesWeight(this.reclaimDeletesWeight);
        return mergePolicy;
    }

    @Override
    public void close(boolean delete) throws ElasticSearchException {
        this.indexSettingsService.removeListener(this.applySettings);
    }

    static {
        IndexMetaData.addDynamicSettings("index.merge.policy.expunge_deletes_allowed", "index.merge.policy.floor_segment", "index.merge.policy.max_merge_at_once", "index.merge.policy.max_merge_at_once_explicit", "index.merge.policy.max_merged_segment", "index.merge.policy.segments_per_tier", "index.merge.policy.reclaim_deletes_weight", "index.compound_format");
    }

    public static class EnableMergeTieredMergePolicyProvider
    extends CustomTieredMergePolicyProvider
    implements EnableMergePolicy {
        private final ThreadLocal<Boolean> enableMerge = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };

        public EnableMergeTieredMergePolicyProvider(TieredMergePolicyProvider provider) {
            super(provider);
        }

        @Override
        public void enableMerge() {
            this.enableMerge.set(Boolean.TRUE);
        }

        @Override
        public void disableMerge() {
            this.enableMerge.set(Boolean.FALSE);
        }

        @Override
        public boolean isMergeEnabled() {
            return this.enableMerge.get() == Boolean.TRUE;
        }

        @Override
        public void close() {
            this.enableMerge.remove();
            super.close();
        }

        @Override
        public MergePolicy.MergeSpecification findMerges(SegmentInfos infos) throws IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findMerges(infos);
        }

        @Override
        public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos infos, int maxSegmentCount, Map<SegmentInfo, Boolean> segmentsToMerge) throws IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findForcedMerges(infos, maxSegmentCount, segmentsToMerge);
        }

        @Override
        public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos infos) throws CorruptIndexException, IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findForcedDeletesMerges(infos);
        }
    }

    public static class CustomTieredMergePolicyProvider
    extends TieredMergePolicy {
        private final TieredMergePolicyProvider provider;

        public CustomTieredMergePolicyProvider(TieredMergePolicyProvider provider) {
            this.provider = provider;
        }

        @Override
        public void close() {
            super.close();
            this.provider.policies.remove(this);
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            boolean compoundFormat;
            double reclaimDeletesWeight;
            double segmentsPerTier;
            ByteSizeValue maxMergedSegment;
            int maxMergeAtOnceExplicit;
            int maxMergeAtOnce;
            ByteSizeValue floorSegment;
            double expungeDeletesPctAllowed = settings.getAsDouble("index.merge.policy.expunge_deletes_allowed", TieredMergePolicyProvider.this.forceMergeDeletesPctAllowed);
            if (expungeDeletesPctAllowed != TieredMergePolicyProvider.this.forceMergeDeletesPctAllowed) {
                TieredMergePolicyProvider.this.logger.info("updating [expunge_deletes_allowed] from [{}] to [{}]", TieredMergePolicyProvider.this.forceMergeDeletesPctAllowed, expungeDeletesPctAllowed);
                TieredMergePolicyProvider.this.forceMergeDeletesPctAllowed = expungeDeletesPctAllowed;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setForceMergeDeletesPctAllowed(expungeDeletesPctAllowed);
                }
            }
            if (!(floorSegment = settings.getAsBytesSize("index.merge.policy.floor_segment", TieredMergePolicyProvider.this.floorSegment)).equals(TieredMergePolicyProvider.this.floorSegment)) {
                TieredMergePolicyProvider.this.logger.info("updating [floor_segment] from [{}] to [{}]", TieredMergePolicyProvider.this.floorSegment, floorSegment);
                TieredMergePolicyProvider.this.floorSegment = floorSegment;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setFloorSegmentMB(floorSegment.mbFrac());
                }
            }
            if ((maxMergeAtOnce = settings.getAsInt("index.merge.policy.max_merge_at_once", TieredMergePolicyProvider.this.maxMergeAtOnce).intValue()) != TieredMergePolicyProvider.this.maxMergeAtOnce) {
                TieredMergePolicyProvider.this.logger.info("updating [max_merge_at_once] from [{}] to [{}]", TieredMergePolicyProvider.this.maxMergeAtOnce, maxMergeAtOnce);
                TieredMergePolicyProvider.this.maxMergeAtOnce = maxMergeAtOnce;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setMaxMergeAtOnce(maxMergeAtOnce);
                }
            }
            if ((maxMergeAtOnceExplicit = settings.getAsInt("index.merge.policy.max_merge_at_once_explicit", TieredMergePolicyProvider.this.maxMergeAtOnceExplicit).intValue()) != TieredMergePolicyProvider.this.maxMergeAtOnceExplicit) {
                TieredMergePolicyProvider.this.logger.info("updating [max_merge_at_once_explicit] from [{}] to [{}]", TieredMergePolicyProvider.this.maxMergeAtOnceExplicit, maxMergeAtOnceExplicit);
                TieredMergePolicyProvider.this.maxMergeAtOnceExplicit = maxMergeAtOnceExplicit;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setMaxMergeAtOnceExplicit(maxMergeAtOnceExplicit);
                }
            }
            if (!(maxMergedSegment = settings.getAsBytesSize("index.merge.policy.max_merged_segment", TieredMergePolicyProvider.this.maxMergedSegment)).equals(TieredMergePolicyProvider.this.maxMergedSegment)) {
                TieredMergePolicyProvider.this.logger.info("updating [max_merged_segment] from [{}] to [{}]", TieredMergePolicyProvider.this.maxMergedSegment, maxMergedSegment);
                TieredMergePolicyProvider.this.maxMergedSegment = maxMergedSegment;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setFloorSegmentMB(maxMergedSegment.mbFrac());
                }
            }
            if ((segmentsPerTier = settings.getAsDouble("index.merge.policy.segments_per_tier", TieredMergePolicyProvider.this.segmentsPerTier).doubleValue()) != TieredMergePolicyProvider.this.segmentsPerTier) {
                TieredMergePolicyProvider.this.logger.info("updating [segments_per_tier] from [{}] to [{}]", TieredMergePolicyProvider.this.segmentsPerTier, segmentsPerTier);
                TieredMergePolicyProvider.this.segmentsPerTier = segmentsPerTier;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setSegmentsPerTier(segmentsPerTier);
                }
            }
            if ((reclaimDeletesWeight = settings.getAsDouble("index.merge.policy.reclaim_deletes_weight", TieredMergePolicyProvider.this.reclaimDeletesWeight).doubleValue()) != TieredMergePolicyProvider.this.reclaimDeletesWeight) {
                TieredMergePolicyProvider.this.logger.info("updating [reclaim_deletes_weight] from [{}] to [{}]", TieredMergePolicyProvider.this.reclaimDeletesWeight, reclaimDeletesWeight);
                TieredMergePolicyProvider.this.reclaimDeletesWeight = reclaimDeletesWeight;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setReclaimDeletesWeight(reclaimDeletesWeight);
                }
            }
            if ((compoundFormat = settings.getAsBoolean("index.compound_format", TieredMergePolicyProvider.this.compoundFormat).booleanValue()) != TieredMergePolicyProvider.this.compoundFormat) {
                TieredMergePolicyProvider.this.logger.info("updating index.compound_format from [{}] to [{}]", TieredMergePolicyProvider.this.compoundFormat, compoundFormat);
                TieredMergePolicyProvider.this.compoundFormat = compoundFormat;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setUseCompoundFile(compoundFormat);
                }
            }
            TieredMergePolicyProvider.this.fixSettingsIfNeeded();
        }
    }
}

