/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class BoolQueryParser
implements QueryParser {
    public static final String NAME = "bool";

    @Inject
    public BoolQueryParser(Settings settings) {
        BooleanQuery.setMaxClauseCount(settings.getAsInt("index.query.bool.max_clause_count", settings.getAsInt("indices.query.bool.max_clause_count", BooleanQuery.getMaxClauseCount())));
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean disableCoord = false;
        float boost = 1.0f;
        int minimumNumberShouldMatch = -1;
        ArrayList<BooleanClause> clauses = Lists.newArrayList();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("must".equals(currentFieldName)) {
                    clauses.add(new BooleanClause(parseContext.parseInnerQuery(), BooleanClause.Occur.MUST));
                    continue;
                }
                if ("must_not".equals(currentFieldName) || "mustNot".equals(currentFieldName)) {
                    clauses.add(new BooleanClause(parseContext.parseInnerQuery(), BooleanClause.Occur.MUST_NOT));
                    continue;
                }
                if ("should".equals(currentFieldName)) {
                    clauses.add(new BooleanClause(parseContext.parseInnerQuery(), BooleanClause.Occur.SHOULD));
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[bool] query does not support [" + currentFieldName + "]");
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("must".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        clauses.add(new BooleanClause(parseContext.parseInnerQuery(), BooleanClause.Occur.MUST));
                    }
                    continue;
                }
                if ("must_not".equals(currentFieldName) || "mustNot".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        clauses.add(new BooleanClause(parseContext.parseInnerQuery(), BooleanClause.Occur.MUST_NOT));
                    }
                    continue;
                }
                if ("should".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        clauses.add(new BooleanClause(parseContext.parseInnerQuery(), BooleanClause.Occur.SHOULD));
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "bool query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("disable_coord".equals(currentFieldName) || "disableCoord".equals(currentFieldName)) {
                disableCoord = parser.booleanValue();
                continue;
            }
            if ("minimum_number_should_match".equals(currentFieldName) || "minimumNumberShouldMatch".equals(currentFieldName)) {
                minimumNumberShouldMatch = parser.intValue();
                continue;
            }
            if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                minimumNumberShouldMatch = parser.intValue();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[bool] query does not support [" + currentFieldName + "]");
        }
        if (clauses.size() == 1) {
            BooleanClause clause = (BooleanClause)clauses.get(0);
            if (clause.getOccur() == BooleanClause.Occur.MUST) {
                Query query = clause.getQuery();
                query.setBoost(boost * query.getBoost());
                return query;
            }
            if (clause.getOccur() == BooleanClause.Occur.SHOULD && minimumNumberShouldMatch > 0) {
                Query query = clause.getQuery();
                query.setBoost(boost * query.getBoost());
                return query;
            }
        }
        BooleanQuery query = new BooleanQuery(disableCoord);
        for (BooleanClause clause : clauses) {
            query.add(clause);
        }
        query.setBoost(boost);
        if (minimumNumberShouldMatch != -1) {
            query.setMinimumNumberShouldMatch(minimumNumberShouldMatch);
        }
        return Queries.optimizeQuery(Queries.fixNegativeQueryIfNeeded(query));
    }
}

