/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;

public class PrefixQueryBuilder
extends BaseQueryBuilder {
    private final String name;
    private final String prefix;
    private float boost = -1.0f;
    private String rewrite;

    public PrefixQueryBuilder(String name, String prefix) {
        this.name = name;
        this.prefix = prefix;
    }

    public PrefixQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public PrefixQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("prefix");
        if (this.boost == -1.0f && this.rewrite == null) {
            builder.field(this.name, this.prefix);
        } else {
            builder.startObject(this.name);
            builder.field("prefix", this.prefix);
            if (this.boost != -1.0f) {
                builder.field("boost", this.boost);
            }
            if (this.rewrite != null) {
                builder.field("rewrite", this.rewrite);
            }
            builder.endObject();
        }
        builder.endObject();
    }
}

