/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

public class GeoUtils {
    public static double normalizeLon(double lon) {
        return GeoUtils.centeredModulus(lon, 360.0);
    }

    public static double normalizeLat(double lat) {
        return GeoUtils.centeredModulus(lat, 180.0);
    }

    private static double centeredModulus(double dividend, double divisor) {
        double rtn = dividend % divisor;
        if (rtn <= 0.0) {
            rtn += divisor;
        }
        if (rtn > divisor / 2.0) {
            rtn -= divisor;
        }
        return rtn;
    }
}

