/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.OpenBufferedIndexOutput;
import org.apache.lucene.store.SimpleFSDirectory;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Directories;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.store.support.ForceSyncDirectory;

public class Store
extends AbstractIndexShardComponent {
    static final String CHECKSUMS_PREFIX = "_checksums-";
    private final IndexStore indexStore;
    private final DirectoryService directoryService;
    private final StoreDirectory directory;
    private volatile ImmutableMap<String, StoreFileMetaData> filesMetadata = ImmutableMap.of();
    private volatile String[] files = Strings.EMPTY_ARRAY;
    private final Object mutex = new Object();
    private final boolean sync;

    public static final boolean isChecksum(String name) {
        return name.startsWith(CHECKSUMS_PREFIX);
    }

    @Inject
    public Store(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore, DirectoryService directoryService) throws IOException {
        super(shardId, indexSettings);
        this.indexStore = indexStore;
        this.directoryService = directoryService;
        this.sync = this.componentSettings.getAsBoolean("sync", true);
        this.directory = new StoreDirectory(directoryService.build());
    }

    public Directory directory() {
        return this.directory;
    }

    public ImmutableMap<String, StoreFileMetaData> list() throws IOException {
        ImmutableMap.Builder<String, StoreFileMetaData> builder = ImmutableMap.builder();
        for (String name : this.files) {
            StoreFileMetaData md = this.metaData(name);
            if (md == null) continue;
            builder.put(md.name(), md);
        }
        return builder.build();
    }

    public StoreFileMetaData metaData(String name) throws IOException {
        StoreFileMetaData md = this.filesMetadata.get(name);
        if (md == null) {
            return null;
        }
        if (md.lastModified() == -1L || md.length() == -1L) {
            return null;
        }
        return md;
    }

    public void deleteContent() throws IOException {
        String[] files = this.directory.listAll();
        IOException lastException = null;
        for (String file : files) {
            if (Store.isChecksum(file)) {
                try {
                    this.directory.deleteFileChecksum(file);
                }
                catch (IOException e) {
                    lastException = e;
                }
                continue;
            }
            try {
                this.directory.deleteFile(file);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    public void fullDelete() throws IOException {
        this.deleteContent();
        for (Directory delegate : this.directory.delegates()) {
            this.directoryService.fullDelete(delegate);
        }
    }

    public StoreStats stats() throws IOException {
        return new StoreStats(Directories.estimateSize(this.directory));
    }

    public ByteSizeValue estimateSize() throws IOException {
        return new ByteSizeValue(Directories.estimateSize(this.directory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFile(String from, String to) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            StoreFileMetaData fromMetaData = this.filesMetadata.get(from);
            if (fromMetaData == null) {
                throw new FileNotFoundException(from);
            }
            this.directoryService.renameFile(fromMetaData.directory(), from, to);
            StoreFileMetaData toMetaData = new StoreFileMetaData(to, fromMetaData.length(), fromMetaData.lastModified(), fromMetaData.checksum(), fromMetaData.directory());
            this.filesMetadata = MapBuilder.newMapBuilder(this.filesMetadata).remove(from).put(to, toMetaData).immutableMap();
            this.files = ((ImmutableCollection)((Object)this.filesMetadata.keySet())).toArray(new String[this.filesMetadata.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readChecksums(File[] locations) throws IOException {
        Directory[] dirs = new Directory[locations.length];
        try {
            for (int i = 0; i < locations.length; ++i) {
                dirs[i] = new SimpleFSDirectory(locations[i]);
            }
            Map<String, String> map = Store.readChecksums(dirs, null);
            return map;
        }
        finally {
            for (Directory dir : dirs) {
                if (dir == null) continue;
                try {
                    dir.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> readChecksums(Directory[] dirs, Map<String, String> defaultValue) throws IOException {
        long lastFound = -1L;
        Directory lastDir = null;
        for (Directory dir : dirs) {
            for (String name : dir.listAll()) {
                long current;
                if (!Store.isChecksum(name) || (current = Long.parseLong(name.substring(CHECKSUMS_PREFIX.length()))) <= lastFound) continue;
                lastFound = current;
                lastDir = dir;
            }
        }
        if (lastFound == -1L) {
            return defaultValue;
        }
        IndexInput indexInput = lastDir.openInput(CHECKSUMS_PREFIX + lastFound);
        try {
            indexInput.readInt();
            Map<String, String> len$ = indexInput.readStringStringMap();
            return len$;
        }
        catch (Exception e) {
            Map<String, String> map = defaultValue;
            return map;
        }
        finally {
            indexInput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChecksums() throws IOException {
        String checksumName = CHECKSUMS_PREFIX + System.currentTimeMillis();
        ImmutableMap<String, StoreFileMetaData> files = this.list();
        Object object = this.mutex;
        synchronized (object) {
            HashMap<String, String> checksums = new HashMap<String, String>();
            for (StoreFileMetaData metaData : files.values()) {
                if (metaData.checksum() == null) continue;
                checksums.put(metaData.name(), metaData.checksum());
            }
            IndexOutput output = this.directory.createOutput(checksumName, false);
            output.writeInt(0);
            output.writeStringStringMap(checksums);
            output.close();
        }
        for (StoreFileMetaData metaData : files.values()) {
            if (!metaData.name().startsWith(CHECKSUMS_PREFIX) || checksumName.equals(metaData.name())) continue;
            try {
                this.directory.deleteFileChecksum(metaData.name());
            }
            catch (Exception e) {}
        }
    }

    public boolean suggestUseCompoundFile() {
        return false;
    }

    public void close() throws IOException {
        this.directory.close();
    }

    public IndexOutput createOutputWithNoChecksum(String name) throws IOException {
        return this.directory.createOutput(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChecksum(String name, String checksum) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            StoreFileMetaData metaData = this.filesMetadata.get(name);
            metaData = new StoreFileMetaData(metaData.name(), metaData.length(), metaData.lastModified(), checksum, metaData.directory());
            this.filesMetadata = MapBuilder.newMapBuilder(this.filesMetadata).put(name, metaData).immutableMap();
            this.writeChecksums();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChecksums(Map<String, String> checksums) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            for (Map.Entry<String, String> entry : checksums.entrySet()) {
                StoreFileMetaData metaData = this.filesMetadata.get(entry.getKey());
                metaData = new StoreFileMetaData(metaData.name(), metaData.length(), metaData.lastModified(), entry.getValue(), metaData.directory());
                this.filesMetadata = MapBuilder.newMapBuilder(this.filesMetadata).put(entry.getKey(), metaData).immutableMap();
            }
            this.writeChecksums();
        }
    }

    static /* synthetic */ String[] access$202(Store x0, String[] x1) {
        x0.files = x1;
        return x1;
    }

    class StoreIndexOutput
    extends OpenBufferedIndexOutput {
        private final StoreFileMetaData metaData;
        private final IndexOutput delegate;
        private final String name;
        private final Checksum digest;

        StoreIndexOutput(StoreFileMetaData metaData, IndexOutput delegate, String name, boolean computeChecksum) {
            super(16448);
            this.metaData = metaData;
            this.delegate = delegate;
            this.name = name;
            this.digest = computeChecksum ? ("segments.gen".equals(name) ? null : (name.startsWith("segments") ? null : new Adler32())) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            super.close();
            this.delegate.close();
            String checksum = null;
            if (this.digest != null) {
                checksum = Long.toString(this.digest.getValue(), 36);
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                StoreFileMetaData md = new StoreFileMetaData(this.name, this.metaData.directory().fileLength(this.name), this.metaData.directory().fileModified(this.name), checksum, this.metaData.directory());
                Store.this.filesMetadata = MapBuilder.newMapBuilder(Store.this.filesMetadata).put(this.name, md).immutableMap();
                Store.access$202(Store.this, ((ImmutableCollection)((Object)Store.this.filesMetadata.keySet())).toArray(new String[Store.this.filesMetadata.size()]));
            }
        }

        @Override
        protected void flushBuffer(byte[] b, int offset, int len) throws IOException {
            this.delegate.writeBytes(b, offset, len);
            if (this.digest != null) {
                this.digest.update(b, offset, len);
            }
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.delegate.flush();
        }

        @Override
        public void seek(long pos) throws IOException {
            super.seek(pos);
            this.delegate.seek(pos);
        }

        @Override
        public long length() throws IOException {
            return this.delegate.length();
        }

        @Override
        public void setLength(long length) throws IOException {
            this.delegate.setLength(length);
        }
    }

    class StoreDirectory
    extends Directory
    implements ForceSyncDirectory {
        private final Directory[] delegates;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StoreDirectory(Directory[] delegates) throws IOException {
            this.delegates = delegates;
            Object object = Store.this.mutex;
            synchronized (object) {
                MapBuilder<String, StoreFileMetaData> builder = MapBuilder.newMapBuilder();
                Map<String, String> checksums = Store.readChecksums(delegates, new HashMap<String, String>());
                for (Directory delegate : delegates) {
                    for (String file : delegate.listAll()) {
                        String checksum = checksums.get(file);
                        builder.put(file, new StoreFileMetaData(file, delegate.fileLength(file), delegate.fileModified(file), checksum, delegate));
                    }
                }
                Store.this.filesMetadata = builder.immutableMap();
                Store.access$202(Store.this, ((ImmutableCollection)((Object)Store.this.filesMetadata.keySet())).toArray(new String[Store.this.filesMetadata.size()]));
            }
        }

        public Directory[] delegates() {
            return this.delegates;
        }

        @Override
        public String[] listAll() throws IOException {
            return Store.this.files;
        }

        @Override
        public boolean fileExists(String name) throws IOException {
            return Store.this.filesMetadata.containsKey(name);
        }

        @Override
        public long fileModified(String name) throws IOException {
            StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
            if (metaData == null) {
                throw new FileNotFoundException(name);
            }
            if (metaData.lastModified() != -1L) {
                return metaData.lastModified();
            }
            return metaData.directory().fileModified(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void touchFile(String name) throws IOException {
            Object object = Store.this.mutex;
            synchronized (object) {
                StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
                if (metaData != null) {
                    metaData.directory().touchFile(name);
                    metaData = new StoreFileMetaData(metaData.name(), metaData.length(), metaData.directory().fileModified(name), metaData.checksum(), metaData.directory());
                    Store.this.filesMetadata = MapBuilder.newMapBuilder(Store.this.filesMetadata).put(name, metaData).immutableMap();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteFileChecksum(String name) throws IOException {
            block6: {
                StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
                if (metaData != null) {
                    try {
                        metaData.directory().deleteFile(name);
                    }
                    catch (IOException e) {
                        if (!metaData.directory().fileExists(name)) break block6;
                        throw e;
                    }
                }
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                Store.this.filesMetadata = MapBuilder.newMapBuilder(Store.this.filesMetadata).remove(name).immutableMap();
                Store.access$202(Store.this, ((ImmutableCollection)((Object)Store.this.filesMetadata.keySet())).toArray(new String[Store.this.filesMetadata.size()]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteFile(String name) throws IOException {
            block7: {
                if (Store.isChecksum(name)) {
                    return;
                }
                StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
                if (metaData != null) {
                    try {
                        metaData.directory().deleteFile(name);
                    }
                    catch (IOException e) {
                        if (!metaData.directory().fileExists(name)) break block7;
                        throw e;
                    }
                }
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                Store.this.filesMetadata = MapBuilder.newMapBuilder(Store.this.filesMetadata).remove(name).immutableMap();
                Store.access$202(Store.this, ((ImmutableCollection)((Object)Store.this.filesMetadata.keySet())).toArray(new String[Store.this.filesMetadata.size()]));
            }
        }

        @Override
        public long fileLength(String name) throws IOException {
            StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
            if (metaData == null) {
                throw new FileNotFoundException(name);
            }
            if (metaData.length() != -1L) {
                return metaData.length();
            }
            return metaData.directory().fileLength(name);
        }

        @Override
        public IndexOutput createOutput(String name) throws IOException {
            return this.createOutput(name, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexOutput createOutput(String name, boolean computeChecksum) throws IOException {
            Directory directory = null;
            if (Store.isChecksum(name)) {
                directory = this.delegates[0];
            } else if (this.delegates.length == 1) {
                directory = this.delegates[0];
            } else {
                long size = Long.MIN_VALUE;
                for (Directory delegate : this.delegates) {
                    if (delegate instanceof FSDirectory) {
                        long currentSize = ((FSDirectory)delegate).getDirectory().getUsableSpace();
                        if (currentSize > size) {
                            size = currentSize;
                            directory = delegate;
                            continue;
                        }
                        if (currentSize != size || !ThreadLocalRandom.current().nextBoolean()) continue;
                        directory = delegate;
                        continue;
                    }
                    directory = delegate;
                }
            }
            IndexOutput out = directory.createOutput(name);
            Object object = Store.this.mutex;
            synchronized (object) {
                StoreFileMetaData metaData = new StoreFileMetaData(name, -1L, -1L, null, directory);
                Store.this.filesMetadata = MapBuilder.newMapBuilder(Store.this.filesMetadata).put(name, metaData).immutableMap();
                Store.access$202(Store.this, ((ImmutableCollection)((Object)Store.this.filesMetadata.keySet())).toArray(new String[Store.this.filesMetadata.size()]));
                return new StoreIndexOutput(metaData, out, name, computeChecksum);
            }
        }

        @Override
        public IndexInput openInput(String name) throws IOException {
            StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
            if (metaData == null) {
                throw new FileNotFoundException(name);
            }
            return metaData.directory().openInput(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            for (Directory delegate : this.delegates) {
                delegate.close();
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                Store.this.filesMetadata = ImmutableMap.of();
                Store.access$202(Store.this, Strings.EMPTY_ARRAY);
            }
        }

        @Override
        public Lock makeLock(String name) {
            return this.delegates[0].makeLock(name);
        }

        @Override
        public IndexInput openInput(String name, int bufferSize) throws IOException {
            StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
            if (metaData == null) {
                throw new FileNotFoundException(name);
            }
            return metaData.directory().openInput(name, bufferSize);
        }

        @Override
        public void clearLock(String name) throws IOException {
            this.delegates[0].clearLock(name);
        }

        @Override
        public void setLockFactory(LockFactory lockFactory) throws IOException {
            this.delegates[0].setLockFactory(lockFactory);
        }

        @Override
        public LockFactory getLockFactory() {
            return this.delegates[0].getLockFactory();
        }

        @Override
        public String getLockID() {
            return this.delegates[0].getLockID();
        }

        @Override
        public void sync(Collection<String> names) throws IOException {
            if (Store.this.sync) {
                HashMap map = Maps.newHashMap();
                for (String string : names) {
                    StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(string);
                    if (metaData == null) {
                        throw new FileNotFoundException(string);
                    }
                    ArrayList<String> dirNames = (ArrayList<String>)map.get(metaData.directory());
                    if (dirNames == null) {
                        dirNames = new ArrayList<String>();
                        map.put(metaData.directory(), dirNames);
                    }
                    dirNames.add(string);
                }
                for (Map.Entry entry : map.entrySet()) {
                    ((Directory)entry.getKey()).sync((Collection)entry.getValue());
                }
            }
            for (String name : names) {
                if (name.equals("segments.gen") || !name.startsWith("segments")) continue;
                Store.this.writeChecksums();
                break;
            }
        }

        @Override
        public void sync(String name) throws IOException {
            if (Store.this.sync) {
                this.sync(ImmutableList.of(name));
            }
            if (!name.equals("segments.gen") && name.startsWith("segments")) {
                Store.this.writeChecksums();
            }
        }

        @Override
        public void forceSync(String name) throws IOException {
            this.sync(ImmutableList.of(name));
        }
    }
}

