/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.VoidStreamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.RecoveryCleanFilesRequest;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryFileChunkRequest;
import org.elasticsearch.indices.recovery.RecoveryFilesInfoRequest;
import org.elasticsearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.elasticsearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoveryStatus;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class RecoveryTarget
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final RecoverySettings recoverySettings;
    private final ConcurrentMap<ShardId, RecoveryStatus> onGoingRecoveries = ConcurrentCollections.newConcurrentMap();

    @Inject
    public RecoveryTarget(Settings settings, ThreadPool threadPool, TransportService transportService, IndicesService indicesService, IndicesLifecycle indicesLifecycle, RecoverySettings recoverySettings) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.recoverySettings = recoverySettings;
        transportService.registerHandler("index/shard/recovery/filesInfo", new FilesInfoRequestHandler());
        transportService.registerHandler("index/shard/recovery/fileChunk", new FileChunkTransportRequestHandler());
        transportService.registerHandler("index/shard/recovery/cleanFiles", new CleanFilesRequestHandler());
        transportService.registerHandler("index/shard/recovery/prepareTranslog", new PrepareForTranslogOperationsRequestHandler());
        transportService.registerHandler("index/shard/recovery/translogOps", new TranslogOperationsRequestHandler());
        transportService.registerHandler("index/shard/recovery/finalize", new FinalizeRecoveryRequestHandler());
        indicesLifecycle.addListener(new IndicesLifecycle.Listener(){

            @Override
            public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, boolean delete) {
                RecoveryTarget.this.removeAndCleanOnGoingRecovery(shardId);
            }
        });
    }

    public RecoveryStatus peerRecoveryStatus(ShardId shardId) {
        RecoveryStatus peerRecoveryStatus = (RecoveryStatus)this.onGoingRecoveries.get(shardId);
        if (peerRecoveryStatus == null) {
            return null;
        }
        if (peerRecoveryStatus.startTime > 0L && peerRecoveryStatus.stage != RecoveryStatus.Stage.DONE) {
            peerRecoveryStatus.time = System.currentTimeMillis() - peerRecoveryStatus.startTime;
        }
        return peerRecoveryStatus;
    }

    public void startRecovery(final StartRecoveryRequest request, final boolean fromRetry, final RecoveryListener listener) {
        if (request.sourceNode() == null) {
            listener.onIgnoreRecovery(false, "No node to recover from, retry on next cluster state update");
            return;
        }
        IndexService indexService = this.indicesService.indexService(request.shardId().index().name());
        if (indexService == null) {
            this.removeAndCleanOnGoingRecovery(request.shardId());
            listener.onIgnoreRecovery(false, "index missing locally, stop recovery");
            return;
        }
        final InternalIndexShard shard = (InternalIndexShard)indexService.shard(request.shardId().id());
        if (shard == null) {
            this.removeAndCleanOnGoingRecovery(request.shardId());
            listener.onIgnoreRecovery(false, "shard missing locally, stop recovery");
            return;
        }
        if (!fromRetry) {
            try {
                shard.recovering("from " + request.sourceNode());
            }
            catch (IllegalIndexShardStateException e) {
                listener.onIgnoreRecovery(false, "already in recovering process, " + e.getMessage());
                return;
            }
        }
        if (shard.state() == IndexShardState.CLOSED) {
            this.removeAndCleanOnGoingRecovery(request.shardId());
            listener.onIgnoreRecovery(false, "local shard closed, stop recovery");
            return;
        }
        this.threadPool.generic().execute(new Runnable(){

            @Override
            public void run() {
                RecoveryTarget.this.doRecovery(shard, request, fromRetry, listener);
            }
        });
    }

    private void doRecovery(InternalIndexShard shard, StartRecoveryRequest request, boolean fromRetry, RecoveryListener listener) {
        if (shard.state() == IndexShardState.CLOSED) {
            this.removeAndCleanOnGoingRecovery(request.shardId());
            listener.onIgnoreRecovery(false, "local shard closed, stop recovery");
            return;
        }
        if (fromRetry) {
            RecoveryStatus recovery = (RecoveryStatus)this.onGoingRecoveries.get(request.shardId());
        } else {
            RecoveryStatus recovery = new RecoveryStatus();
            this.onGoingRecoveries.put(request.shardId(), recovery);
        }
        try {
            this.logger.trace("[{}][{}] starting recovery from {}", request.shardId().index().name(), request.shardId().id(), request.sourceNode());
            StopWatch stopWatch = new StopWatch().start();
            RecoveryResponse recoveryStatus = this.transportService.submitRequest(request.sourceNode(), "index/shard/recovery/startRecovery", request, new FutureTransportResponseHandler<RecoveryResponse>(){

                @Override
                public RecoveryResponse newInstance() {
                    return new RecoveryResponse();
                }
            }).txGet();
            if (shard.state() == IndexShardState.CLOSED) {
                this.removeAndCleanOnGoingRecovery(shard.shardId());
                listener.onIgnoreRecovery(false, "local shard closed, stop recovery");
                return;
            }
            stopWatch.stop();
            if (this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append('[').append(request.shardId().index().name()).append(']').append('[').append(request.shardId().id()).append("] ");
                sb.append("recovery completed from ").append(request.sourceNode()).append(", took[").append(stopWatch.totalTime()).append("]\n");
                sb.append("   phase1: recovered_files [").append(recoveryStatus.phase1FileNames.size()).append("]").append(" with total_size of [").append(new ByteSizeValue(recoveryStatus.phase1TotalSize)).append("]").append(", took [").append(TimeValue.timeValueMillis(recoveryStatus.phase1Time)).append("], throttling_wait [").append(TimeValue.timeValueMillis(recoveryStatus.phase1ThrottlingWaitTime)).append(']').append("\n");
                sb.append("         : reusing_files   [").append(recoveryStatus.phase1ExistingFileNames.size()).append("] with total_size of [").append(new ByteSizeValue(recoveryStatus.phase1ExistingTotalSize)).append("]\n");
                sb.append("   phase2: start took [").append(TimeValue.timeValueMillis(recoveryStatus.startTime)).append("]\n");
                sb.append("         : recovered [").append(recoveryStatus.phase2Operations).append("]").append(" transaction log operations").append(", took [").append(TimeValue.timeValueMillis(recoveryStatus.phase2Time)).append("]").append("\n");
                sb.append("   phase3: recovered [").append(recoveryStatus.phase3Operations).append("]").append(" transaction log operations").append(", took [").append(TimeValue.timeValueMillis(recoveryStatus.phase3Time)).append("]");
                this.logger.debug(sb.toString(), new Object[0]);
            }
            this.removeAndCleanOnGoingRecovery(request.shardId());
            listener.onRecoveryDone();
        }
        catch (Exception e) {
            if (shard.state() == IndexShardState.CLOSED) {
                this.removeAndCleanOnGoingRecovery(request.shardId());
                listener.onIgnoreRecovery(false, "local shard closed, stop recovery");
                return;
            }
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            if (cause instanceof RecoveryEngineException) {
                cause = cause.getCause();
            }
            if ((cause = ExceptionsHelper.unwrapCause(cause)) instanceof RecoveryEngineException) {
                cause = cause.getCause();
            }
            if (cause instanceof IndexShardNotStartedException || cause instanceof IndexMissingException || cause instanceof IndexShardMissingException) {
                listener.onRetryRecovery(TimeValue.timeValueMillis(500L));
                return;
            }
            this.removeAndCleanOnGoingRecovery(request.shardId());
            if (cause instanceof ConnectTransportException) {
                listener.onIgnoreRecovery(true, "source node disconnected (" + request.sourceNode() + ")");
                return;
            }
            if (cause instanceof IndexShardClosedException) {
                listener.onIgnoreRecovery(true, "source shard is closed (" + request.sourceNode() + ")");
                return;
            }
            if (cause instanceof AlreadyClosedException) {
                listener.onIgnoreRecovery(true, "source shard is closed (" + request.sourceNode() + ")");
                return;
            }
            this.logger.trace("[{}][{}] recovery from [{}] failed", e, request.shardId().index().name(), request.shardId().id(), request.sourceNode());
            listener.onRecoveryFailure(new RecoveryFailedException(request, (Throwable)e), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAndCleanOnGoingRecovery(ShardId shardId) {
        RecoveryStatus peerRecoveryStatus = (RecoveryStatus)this.onGoingRecoveries.remove(shardId);
        if (peerRecoveryStatus != null) {
            for (Map.Entry entry : peerRecoveryStatus.openIndexOutputs.entrySet()) {
                IndexOutput indexOutput = (IndexOutput)entry.getValue();
                synchronized (indexOutput) {
                    try {
                        ((IndexOutput)entry.getValue()).close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            peerRecoveryStatus.openIndexOutputs = null;
            peerRecoveryStatus.checksums = null;
        }
    }

    class FileChunkTransportRequestHandler
    extends BaseTransportRequestHandler<RecoveryFileChunkRequest> {
        FileChunkTransportRequestHandler() {
        }

        @Override
        public RecoveryFileChunkRequest newInstance() {
            return new RecoveryFileChunkRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageReceived(RecoveryFileChunkRequest request, TransportChannel channel) throws Exception {
            IndexOutput indexOutput;
            InternalIndexShard shard = (InternalIndexShard)RecoveryTarget.this.indicesService.indexServiceSafe(request.shardId().index().name()).shardSafe(request.shardId().id());
            RecoveryStatus onGoingRecovery = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(shard.shardId());
            if (onGoingRecovery == null) {
                throw new IndexShardClosedException(shard.shardId());
            }
            if (request.position() == 0L) {
                onGoingRecovery.checksums.remove(request.name());
                indexOutput = (IndexOutput)onGoingRecovery.openIndexOutputs.remove(request.name());
                if (indexOutput != null) {
                    try {
                        indexOutput.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                String name = request.name();
                if (shard.store().directory().fileExists(name)) {
                    name = name + "." + onGoingRecovery.startTime;
                }
                indexOutput = shard.store().createOutputWithNoChecksum(name);
                onGoingRecovery.openIndexOutputs.put(request.name(), indexOutput);
            } else {
                indexOutput = (IndexOutput)onGoingRecovery.openIndexOutputs.get(request.name());
            }
            if (indexOutput == null) {
                throw new IndexShardClosedException(shard.shardId());
            }
            IndexOutput indexOutput2 = indexOutput;
            synchronized (indexOutput2) {
                try {
                    if (RecoveryTarget.this.recoverySettings.rateLimiter() != null) {
                        RecoveryTarget.this.recoverySettings.rateLimiter().pause(request.content().length());
                    }
                    indexOutput.writeBytes(request.content().bytes(), request.content().offset(), request.content().length());
                    onGoingRecovery.currentFilesSize.addAndGet(request.length());
                    if (indexOutput.getFilePointer() == request.length()) {
                        indexOutput.close();
                        if (request.checksum() != null) {
                            onGoingRecovery.checksums.put(request.name(), request.checksum());
                        }
                        shard.store().directory().sync(Collections.singleton(request.name()));
                        onGoingRecovery.openIndexOutputs.remove(request.name());
                    }
                }
                catch (IOException e) {
                    onGoingRecovery.openIndexOutputs.remove(request.name());
                    try {
                        indexOutput.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            channel.sendResponse(VoidStreamable.INSTANCE);
        }
    }

    class CleanFilesRequestHandler
    extends BaseTransportRequestHandler<RecoveryCleanFilesRequest> {
        CleanFilesRequestHandler() {
        }

        @Override
        public RecoveryCleanFilesRequest newInstance() {
            return new RecoveryCleanFilesRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(RecoveryCleanFilesRequest request, TransportChannel channel) throws Exception {
            InternalIndexShard shard = (InternalIndexShard)RecoveryTarget.this.indicesService.indexServiceSafe(request.shardId().index().name()).shardSafe(request.shardId().id());
            RecoveryStatus onGoingRecovery = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(shard.shardId());
            if (onGoingRecovery == null) {
                throw new IndexShardClosedException(shard.shardId());
            }
            String suffix = "." + onGoingRecovery.startTime;
            HashSet<String> filesToRename = Sets.newHashSet();
            for (String existingFile : shard.store().directory().listAll()) {
                if (!existingFile.endsWith(suffix)) continue;
                filesToRename.add(existingFile.substring(0, existingFile.length() - suffix.length()));
            }
            Exception failureToRename = null;
            if (!filesToRename.isEmpty()) {
                for (String fileToRename : filesToRename) {
                    shard.store().directory().deleteFile(fileToRename);
                }
                for (String fileToRename : filesToRename) {
                    try {
                        shard.store().renameFile(fileToRename + suffix, fileToRename);
                    }
                    catch (Exception e) {
                        failureToRename = e;
                        break;
                    }
                }
            }
            if (failureToRename != null) {
                throw failureToRename;
            }
            shard.store().writeChecksums(onGoingRecovery.checksums);
            for (String existingFile : shard.store().directory().listAll()) {
                if (request.snapshotFiles().contains(existingFile) || Store.isChecksum(existingFile)) continue;
                try {
                    shard.store().directory().deleteFile(existingFile);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            channel.sendResponse(VoidStreamable.INSTANCE);
        }
    }

    class FilesInfoRequestHandler
    extends BaseTransportRequestHandler<RecoveryFilesInfoRequest> {
        FilesInfoRequestHandler() {
        }

        @Override
        public RecoveryFilesInfoRequest newInstance() {
            return new RecoveryFilesInfoRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(RecoveryFilesInfoRequest request, TransportChannel channel) throws Exception {
            InternalIndexShard shard = (InternalIndexShard)RecoveryTarget.this.indicesService.indexServiceSafe(request.shardId.index().name()).shardSafe(request.shardId.id());
            RecoveryStatus onGoingRecovery = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(shard.shardId());
            if (onGoingRecovery == null) {
                throw new IndexShardClosedException(shard.shardId());
            }
            onGoingRecovery.phase1FileNames = request.phase1FileNames;
            onGoingRecovery.phase1FileSizes = request.phase1FileSizes;
            onGoingRecovery.phase1ExistingFileNames = request.phase1ExistingFileNames;
            onGoingRecovery.phase1ExistingFileSizes = request.phase1ExistingFileSizes;
            onGoingRecovery.phase1TotalSize = request.phase1TotalSize;
            onGoingRecovery.phase1ExistingTotalSize = request.phase1ExistingTotalSize;
            onGoingRecovery.stage = RecoveryStatus.Stage.INDEX;
            channel.sendResponse(VoidStreamable.INSTANCE);
        }
    }

    class TranslogOperationsRequestHandler
    extends BaseTransportRequestHandler<RecoveryTranslogOperationsRequest> {
        TranslogOperationsRequestHandler() {
        }

        @Override
        public RecoveryTranslogOperationsRequest newInstance() {
            return new RecoveryTranslogOperationsRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(RecoveryTranslogOperationsRequest request, TransportChannel channel) throws Exception {
            InternalIndexShard shard = (InternalIndexShard)RecoveryTarget.this.indicesService.indexServiceSafe(request.shardId().index().name()).shardSafe(request.shardId().id());
            for (Translog.Operation operation : request.operations()) {
                shard.performRecoveryOperation(operation);
            }
            RecoveryStatus onGoingRecovery = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(shard.shardId());
            if (onGoingRecovery == null) {
                throw new IndexShardClosedException(shard.shardId());
            }
            onGoingRecovery.currentTranslogOperations += (long)request.operations().size();
            channel.sendResponse(VoidStreamable.INSTANCE);
        }
    }

    class FinalizeRecoveryRequestHandler
    extends BaseTransportRequestHandler<RecoveryFinalizeRecoveryRequest> {
        FinalizeRecoveryRequestHandler() {
        }

        @Override
        public RecoveryFinalizeRecoveryRequest newInstance() {
            return new RecoveryFinalizeRecoveryRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(RecoveryFinalizeRecoveryRequest request, TransportChannel channel) throws Exception {
            InternalIndexShard shard = (InternalIndexShard)RecoveryTarget.this.indicesService.indexServiceSafe(request.shardId().index().name()).shardSafe(request.shardId().id());
            RecoveryStatus peerRecoveryStatus = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(shard.shardId());
            if (peerRecoveryStatus == null) {
                throw new IndexShardClosedException(shard.shardId());
            }
            peerRecoveryStatus.stage = RecoveryStatus.Stage.FINALIZE;
            shard.performRecoveryFinalization(false, peerRecoveryStatus);
            peerRecoveryStatus.time = System.currentTimeMillis() - peerRecoveryStatus.startTime;
            peerRecoveryStatus.stage = RecoveryStatus.Stage.DONE;
            channel.sendResponse(VoidStreamable.INSTANCE);
        }
    }

    class PrepareForTranslogOperationsRequestHandler
    extends BaseTransportRequestHandler<RecoveryPrepareForTranslogOperationsRequest> {
        PrepareForTranslogOperationsRequestHandler() {
        }

        @Override
        public RecoveryPrepareForTranslogOperationsRequest newInstance() {
            return new RecoveryPrepareForTranslogOperationsRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(RecoveryPrepareForTranslogOperationsRequest request, TransportChannel channel) throws Exception {
            InternalIndexShard shard = (InternalIndexShard)RecoveryTarget.this.indicesService.indexServiceSafe(request.shardId().index().name()).shardSafe(request.shardId().id());
            RecoveryStatus onGoingRecovery = (RecoveryStatus)RecoveryTarget.this.onGoingRecoveries.get(shard.shardId());
            if (onGoingRecovery == null) {
                throw new IndexShardClosedException(shard.shardId());
            }
            onGoingRecovery.stage = RecoveryStatus.Stage.TRANSLOG;
            shard.performRecoveryPrepareForTranslog();
            channel.sendResponse(VoidStreamable.INSTANCE);
        }
    }

    public static interface RecoveryListener {
        public void onRecoveryDone();

        public void onRetryRecovery(TimeValue var1);

        public void onIgnoreRecovery(boolean var1, String var2);

        public void onRecoveryFailure(RecoveryFailedException var1, boolean var2);
    }

    public static class Actions {
        public static final String FILES_INFO = "index/shard/recovery/filesInfo";
        public static final String FILE_CHUNK = "index/shard/recovery/fileChunk";
        public static final String CLEAN_FILES = "index/shard/recovery/cleanFiles";
        public static final String TRANSLOG_OPS = "index/shard/recovery/translogOps";
        public static final String PREPARE_TRANSLOG = "index/shard/recovery/prepareTranslog";
        public static final String FINALIZE = "index/shard/recovery/finalize";
    }
}

