/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.pojo;

import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import javax.security.auth.Subject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.internal.InternalNode;
import org.elasticsearch.pojo.BaseManagedServiceFactory;
import org.osgi.framework.BundleContext;

public class NodeFactory
extends BaseManagedServiceFactory<Node> {
    private Map<String, String> settings;

    public NodeFactory(BundleContext context, Map<String, String> settings) {
        super(context, "ElasticSearch Node factory");
        this.settings = settings;
    }

    @Override
    protected Node doCreate(final Dictionary properties) {
        return Subject.doAs(null, new PrivilegedAction<Node>(){

            @Override
            public Node run() {
                return NodeFactory.this.doCreateInternal(properties);
            }
        });
    }

    protected Node doCreateInternal(Dictionary properties) {
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder();
        builder.put(this.settings);
        builder.classLoader(NodeFactory.class.getClassLoader());
        if (properties != null) {
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement().toString();
                Object oval = properties.get(key);
                String val = oval != null ? oval.toString() : null;
                builder.put(key, val);
            }
        }
        InternalNode node = new InternalNode(builder.build(), false);
        try {
            node.start();
            node.client().admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().execute().actionGet();
        }
        catch (RuntimeException t) {
            this.doDestroy(node);
            throw t;
        }
        return node;
    }

    @Override
    protected void doDestroy(Node node) {
        node.close();
    }

    @Override
    protected String[] getExposedClasses(Node node) {
        return new String[]{Node.class.getName()};
    }
}

