/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.bulk;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestBulkAction
extends BaseRestHandler {
    @Inject
    public RestBulkAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/_bulk", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_bulk", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_bulk", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_bulk", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_bulk", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_bulk", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String consistencyLevel;
        BulkRequest bulkRequest = Requests.bulkRequest();
        String defaultIndex = request.param("index");
        String defaultType = request.param("type");
        String replicationType = request.param("replication");
        if (replicationType != null) {
            bulkRequest.replicationType(ReplicationType.fromString(replicationType));
        }
        if ((consistencyLevel = request.param("consistency")) != null) {
            bulkRequest.consistencyLevel(WriteConsistencyLevel.fromString(consistencyLevel));
        }
        bulkRequest.refresh(request.paramAsBoolean("refresh", bulkRequest.refresh()));
        try {
            bulkRequest.add(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength(), request.contentUnsafe(), defaultIndex, defaultType);
        }
        catch (Exception e) {
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.BAD_REQUEST, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.bulk(bulkRequest, new ActionListener<BulkResponse>(){

            @Override
            public void onResponse(BulkResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field(Fields.TOOK, response.tookInMillis());
                    builder.startArray(Fields.ITEMS);
                    for (BulkItemResponse itemResponse : response) {
                        IndexResponse indexResponse;
                        builder.startObject();
                        builder.startObject(itemResponse.opType());
                        builder.field(Fields._INDEX, itemResponse.index());
                        builder.field(Fields._TYPE, itemResponse.type());
                        builder.field(Fields._ID, itemResponse.id());
                        long version = itemResponse.version();
                        if (version != -1L) {
                            builder.field(Fields._VERSION, itemResponse.version());
                        }
                        if (itemResponse.failed()) {
                            builder.field(Fields.ERROR, itemResponse.failure().message());
                        } else {
                            builder.field(Fields.OK, true);
                        }
                        if (itemResponse.response() instanceof IndexResponse && (indexResponse = (IndexResponse)itemResponse.response()).matches() != null) {
                            builder.startArray(Fields.MATCHES);
                            for (String match : indexResponse.matches()) {
                                builder.value(match);
                            }
                            builder.endArray();
                        }
                        builder.endObject();
                        builder.endObject();
                    }
                    builder.endArray();
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestBulkAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString ITEMS = new XContentBuilderString("items");
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString ERROR = new XContentBuilderString("error");
        static final XContentBuilderString OK = new XContentBuilderString("ok");
        static final XContentBuilderString TOOK = new XContentBuilderString("took");
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");
        static final XContentBuilderString MATCHES = new XContentBuilderString("matches");

        Fields() {
        }
    }
}

