/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TotalHitCountCollector;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.OptimizeGlobalFacetCollector;
import org.elasticsearch.search.facet.query.InternalQueryFacet;
import org.elasticsearch.search.internal.SearchContext;

public class QueryFacetCollector
extends AbstractFacetCollector
implements OptimizeGlobalFacetCollector {
    private final Query query;
    private final Filter filter;
    private DocSet docSet;
    private int count = 0;

    public QueryFacetCollector(String facetName, Query query, FilterCache filterCache) {
        super(facetName);
        this.query = query;
        Filter possibleFilter = this.extractFilterIfApplicable(query);
        this.filter = possibleFilter != null ? possibleFilter : new QueryWrapperFilter(query);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.docSet = DocSets.convert(reader, this.filter.getDocIdSet(reader));
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        if (this.docSet.get(doc)) {
            ++this.count;
        }
    }

    @Override
    public void optimizedGlobalExecution(SearchContext searchContext) throws IOException {
        Filter searchFilter;
        Query query = this.query;
        if (((AbstractFacetCollector)this).filter != null) {
            query = new FilteredQuery(query, ((AbstractFacetCollector)this).filter);
        }
        if ((searchFilter = searchContext.mapperService().searchFilter(searchContext.types())) != null) {
            query = new FilteredQuery(query, searchContext.filterCache().cache(searchFilter));
        }
        TotalHitCountCollector collector = new TotalHitCountCollector();
        searchContext.searcher().search(query, collector);
        this.count = collector.getTotalHits();
    }

    @Override
    public Facet facet() {
        return new InternalQueryFacet(this.facetName, this.count);
    }

    private Filter extractFilterIfApplicable(Query query) {
        if (query instanceof FilteredQuery) {
            FilteredQuery fQuery = (FilteredQuery)query;
            if (Queries.isMatchAllQuery(fQuery.getQuery())) {
                return fQuery.getFilter();
            }
        } else {
            ConstantScoreQuery constantScoreQuery;
            if (query instanceof DeletionAwareConstantScoreQuery) {
                return ((DeletionAwareConstantScoreQuery)query).getFilter();
            }
            if (query instanceof ConstantScoreQuery && (constantScoreQuery = (ConstantScoreQuery)query).getFilter() != null) {
                return constantScoreQuery.getFilter();
            }
        }
        return null;
    }
}

