/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.range.InternalRangeFacet;
import org.elasticsearch.search.facet.range.RangeFacet;
import org.elasticsearch.search.internal.SearchContext;

public class KeyValueRangeFacetCollector
extends AbstractFacetCollector {
    private final String keyIndexFieldName;
    private final String valueIndexFieldName;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType keyFieldDataType;
    private NumericFieldData keyFieldData;
    private final FieldDataType valueFieldDataType;
    private final RangeFacet.Entry[] entries;
    private final RangeProc rangeProc;

    public KeyValueRangeFacetCollector(String facetName, String keyFieldName, String valueFieldName, RangeFacet.Entry[] entries, SearchContext context) {
        super(facetName);
        this.entries = entries;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.smartFieldMappers(keyFieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + keyFieldName + "]");
        }
        if (smartMappers.explicitTypeInNameWithDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.keyIndexFieldName = smartMappers.mapper().names().indexName();
        this.keyFieldDataType = smartMappers.mapper().fieldDataType();
        smartMappers = context.smartFieldMappers(valueFieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for value_field [" + valueFieldName + "]");
        }
        this.valueIndexFieldName = smartMappers.mapper().names().indexName();
        this.valueFieldDataType = smartMappers.mapper().fieldDataType();
        this.rangeProc = new RangeProc(entries);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.keyFieldData = (NumericFieldData)this.fieldDataCache.cache(this.keyFieldDataType, reader, this.keyIndexFieldName);
        this.rangeProc.valueFieldData = (NumericFieldData)this.fieldDataCache.cache(this.valueFieldDataType, reader, this.valueIndexFieldName);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        for (RangeFacet.Entry entry : this.entries) {
            entry.foundInDoc = false;
        }
        this.keyFieldData.forEachValueInDoc(doc, this.rangeProc);
    }

    @Override
    public Facet facet() {
        return new InternalRangeFacet(this.facetName, this.entries);
    }

    public static class RangeProc
    implements NumericFieldData.DoubleValueInDocProc {
        private final RangeFacet.Entry[] entries;
        NumericFieldData valueFieldData;

        public RangeProc(RangeFacet.Entry[] entries) {
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double value) {
            for (RangeFacet.Entry entry : this.entries) {
                if (entry.foundInDoc || !(value >= entry.getFrom()) || !(value < entry.getTo())) continue;
                entry.foundInDoc = true;
                ++entry.count;
                if (this.valueFieldData.multiValued()) {
                    double[] valuesValues = this.valueFieldData.doubleValues(docId);
                    entry.totalCount += (long)valuesValues.length;
                    for (double valueValue : valuesValues) {
                        entry.total += valueValue;
                        if (valueValue < entry.min) {
                            entry.min = valueValue;
                        }
                        if (!(valueValue > entry.max)) continue;
                        entry.max = valueValue;
                    }
                    continue;
                }
                double valueValue = this.valueFieldData.doubleValue(docId);
                ++entry.totalCount;
                entry.total += valueValue;
                if (valueValue < entry.min) {
                    entry.min = valueValue;
                }
                if (!(valueValue > entry.max)) continue;
                entry.max = valueValue;
            }
        }
    }
}

