/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.range.InternalRangeFacet;
import org.elasticsearch.search.facet.range.KeyValueRangeFacetCollector;
import org.elasticsearch.search.facet.range.RangeFacet;
import org.elasticsearch.search.facet.range.RangeFacetCollector;
import org.elasticsearch.search.facet.range.ScriptRangeFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class RangeFacetProcessor
extends AbstractComponent
implements FacetProcessor {
    @Inject
    public RangeFacetProcessor(Settings settings) {
        super(settings);
        InternalRangeFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"range"};
    }

    @Override
    public FacetCollector parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String keyField = null;
        String valueField = null;
        String scriptLang = null;
        String keyScript = null;
        String valueScript = null;
        Map<String, Object> params = null;
        String fieldName = null;
        ArrayList<RangeFacet.Entry> entries = Lists.newArrayList();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!"ranges".equals(fieldName)) {
                    keyField = fieldName;
                }
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    RangeFacet.Entry entry = new RangeFacet.Entry();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("from".equals(fieldName)) {
                                entry.fromAsString = parser.text();
                                continue;
                            }
                            if (!"to".equals(fieldName)) continue;
                            entry.toAsString = parser.text();
                            continue;
                        }
                        if (!token.isValue()) continue;
                        if ("from".equals(fieldName)) {
                            entry.from = parser.doubleValue();
                            continue;
                        }
                        if (!"to".equals(fieldName)) continue;
                        entry.to = parser.doubleValue();
                    }
                    entries.add(entry);
                }
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(fieldName)) continue;
                params = parser.map();
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("key_field".equals(fieldName) || "keyField".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("value_field".equals(fieldName) || "valueField".equals(fieldName)) {
                valueField = parser.text();
                continue;
            }
            if ("key_script".equals(fieldName) || "keyScript".equals(fieldName)) {
                keyScript = parser.text();
                continue;
            }
            if ("value_script".equals(fieldName) || "valueScript".equals(fieldName)) {
                valueScript = parser.text();
                continue;
            }
            if (!"lang".equals(fieldName)) continue;
            scriptLang = parser.text();
        }
        if (entries.isEmpty()) {
            throw new FacetPhaseExecutionException(facetName, "no ranges defined for range facet");
        }
        RangeFacet.Entry[] rangeEntries = entries.toArray(new RangeFacet.Entry[entries.size()]);
        if (keyField != null) {
            FieldMapper mapper = context.smartNameFieldMapper(keyField);
            if (mapper == null) {
                throw new FacetPhaseExecutionException(facetName, "No mapping found for key_field [" + keyField + "]");
            }
            for (RangeFacet.Entry entry : rangeEntries) {
                if (entry.fromAsString != null) {
                    entry.from = ((Number)mapper.valueFromString(entry.fromAsString)).doubleValue();
                }
                if (entry.toAsString == null) continue;
                entry.to = ((Number)mapper.valueFromString(entry.toAsString)).doubleValue();
            }
        }
        if (keyScript != null && valueScript != null) {
            return new ScriptRangeFacetCollector(facetName, scriptLang, keyScript, valueScript, params, rangeEntries, context);
        }
        if (keyField == null) {
            throw new FacetPhaseExecutionException(facetName, "key field is required to be set for range facet, either using [field] or using [key_field]");
        }
        if (valueField == null || keyField.equals(valueField)) {
            return new RangeFacetCollector(facetName, keyField, rangeEntries, context);
        }
        return new KeyValueRangeFacetCollector(facetName, keyField, valueField, rangeEntries, context);
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        InternalRangeFacet agg = null;
        for (Facet facet : facets) {
            InternalRangeFacet geoDistanceFacet = (InternalRangeFacet)facet;
            if (agg == null) {
                agg = geoDistanceFacet;
                continue;
            }
            for (int i = 0; i < geoDistanceFacet.entries.length; ++i) {
                RangeFacet.Entry aggEntry = agg.entries[i];
                RangeFacet.Entry currentEntry = geoDistanceFacet.entries[i];
                aggEntry.count += currentEntry.count;
                aggEntry.totalCount += currentEntry.totalCount;
                aggEntry.total += currentEntry.total;
                if (currentEntry.min < aggEntry.min) {
                    aggEntry.min = currentEntry.min;
                }
                if (!(currentEntry.max > aggEntry.max)) continue;
                aggEntry.max = currentEntry.max;
            }
        }
        return agg;
    }
}

