/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.statistical.InternalStatisticalFacet;
import org.elasticsearch.search.facet.statistical.ScriptStatisticalFacetCollector;
import org.elasticsearch.search.facet.statistical.StatisticalFacetCollector;
import org.elasticsearch.search.facet.statistical.StatisticalFieldsFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class StatisticalFacetProcessor
extends AbstractComponent
implements FacetProcessor {
    @Inject
    public StatisticalFacetProcessor(Settings settings) {
        super(settings);
        InternalStatisticalFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"statistical"};
    }

    @Override
    public FacetCollector parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String field = null;
        String[] fieldsNames = null;
        String script = null;
        String scriptLang = null;
        Map<String, Object> params = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(currentFieldName)) continue;
                params = parser.map();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!"fields".equals(currentFieldName)) continue;
                ArrayList<String> fields = Lists.newArrayListWithCapacity(4);
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    fields.add(parser.text());
                }
                fieldsNames = fields.toArray(new String[fields.size()]);
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(currentFieldName)) {
                field = parser.text();
                continue;
            }
            if ("script".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if (!"lang".equals(currentFieldName)) continue;
            scriptLang = parser.text();
        }
        if (fieldsNames != null) {
            return new StatisticalFieldsFacetCollector(facetName, fieldsNames, context);
        }
        if (script == null && field == null) {
            throw new FacetPhaseExecutionException(facetName, "statistical facet requires either [script] or [field] to be set");
        }
        if (field != null) {
            return new StatisticalFacetCollector(facetName, field, context);
        }
        return new ScriptStatisticalFacetCollector(facetName, scriptLang, script, params, context);
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        double min = Double.NaN;
        double max = Double.NaN;
        double total = 0.0;
        double sumOfSquares = 0.0;
        long count = 0L;
        for (Facet facet : facets) {
            if (!facet.name().equals(name)) continue;
            InternalStatisticalFacet statsFacet = (InternalStatisticalFacet)facet;
            if (statsFacet.min() < min || Double.isNaN(min)) {
                min = statsFacet.min();
            }
            if (statsFacet.max() > max || Double.isNaN(max)) {
                max = statsFacet.max();
            }
            total += statsFacet.total();
            sumOfSquares += statsFacet.sumOfSquares();
            count += statsFacet.count();
        }
        return new InternalStatisticalFacet(name, min, max, total, sumOfSquares, count);
    }
}

