/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.BytesHolder;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.search.Scroll;

public class InternalSearchRequest
implements Streamable {
    private String index;
    private int shardId;
    private int numberOfShards;
    private SearchType searchType;
    private Scroll scroll;
    private String[] types = Strings.EMPTY_ARRAY;
    private String[] filteringAliases;
    private byte[] source;
    private int sourceOffset;
    private int sourceLength;
    private byte[] extraSource;
    private int extraSourceOffset;
    private int extraSourceLength;
    private long nowInMillis;

    public InternalSearchRequest() {
    }

    public InternalSearchRequest(ShardRouting shardRouting, int numberOfShards, SearchType searchType) {
        this(shardRouting.index(), shardRouting.id(), numberOfShards, searchType);
    }

    public InternalSearchRequest(String index, int shardId, int numberOfShards, SearchType searchType) {
        this.index = index;
        this.shardId = shardId;
        this.numberOfShards = numberOfShards;
        this.searchType = searchType;
    }

    public String index() {
        return this.index;
    }

    public int shardId() {
        return this.shardId;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public byte[] source() {
        return this.source;
    }

    public int sourceOffset() {
        return this.sourceOffset;
    }

    public int sourceLength() {
        return this.sourceLength;
    }

    public byte[] extraSource() {
        return this.extraSource;
    }

    public int extraSourceOffset() {
        return this.extraSourceOffset;
    }

    public int extraSourceLength() {
        return this.extraSourceLength;
    }

    public InternalSearchRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    public InternalSearchRequest source(byte[] source, int offset, int length) {
        this.source = source;
        this.sourceOffset = offset;
        this.sourceLength = length;
        return this;
    }

    public InternalSearchRequest extraSource(byte[] extraSource, int offset, int length) {
        this.extraSource = extraSource;
        this.extraSourceOffset = offset;
        this.extraSourceLength = length;
        return this;
    }

    public InternalSearchRequest nowInMillis(long nowInMillis) {
        this.nowInMillis = nowInMillis;
        return this;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public InternalSearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    public void filteringAliases(String[] filteringAliases) {
        this.filteringAliases = filteringAliases;
    }

    public String[] types() {
        return this.types;
    }

    public void types(String[] types) {
        this.types = types;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int indicesSize;
        this.index = in.readUTF();
        this.shardId = in.readVInt();
        this.searchType = SearchType.fromId(in.readByte());
        this.numberOfShards = in.readVInt();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
        BytesHolder bytes = in.readBytesReference();
        this.source = bytes.bytes();
        this.sourceOffset = bytes.offset();
        this.sourceLength = bytes.length();
        bytes = in.readBytesReference();
        this.extraSource = bytes.bytes();
        this.extraSourceOffset = bytes.offset();
        this.extraSourceLength = bytes.length();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readUTF();
            }
        }
        if ((indicesSize = in.readVInt()) > 0) {
            this.filteringAliases = new String[indicesSize];
            for (int i = 0; i < indicesSize; ++i) {
                this.filteringAliases[i] = in.readUTF();
            }
        } else {
            this.filteringAliases = null;
        }
        this.nowInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.index);
        out.writeVInt(this.shardId);
        out.writeByte(this.searchType.id());
        out.writeVInt(this.numberOfShards);
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
        out.writeBytesHolder(this.source, this.sourceOffset, this.sourceLength);
        out.writeBytesHolder(this.extraSource, this.extraSourceOffset, this.extraSourceLength);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
        if (this.filteringAliases != null) {
            out.writeVInt(this.filteringAliases.length);
            for (String index : this.filteringAliases) {
                out.writeUTF(index);
            }
        } else {
            out.writeVInt(0);
        }
        out.writeVLong(this.nowInMillis);
    }
}

