/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.uberize.filter;

import java.io.File;
import java.util.Set;
import org.codehaus.plexus.util.SelectorUtils;
import org.fusesource.mvnplugins.uberize.filter.Filter;

public class SimpleFilter
implements Filter {
    private File jar;
    private Set includes;
    private Set excludes;

    public SimpleFilter(File jar, Set includes, Set excludes) {
        this.jar = jar;
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean canFilter(File jar) {
        return this.jar.equals(jar);
    }

    public boolean isFiltered(String classFile) {
        return !this.isIncluded(classFile) || this.isExcluded(classFile);
    }

    private boolean isIncluded(String classFile) {
        if (this.includes == null || this.includes.size() == 0) {
            return true;
        }
        return this.matchPaths(this.includes, classFile);
    }

    private boolean isExcluded(String classFile) {
        if (this.excludes == null || this.excludes.size() == 0) {
            return false;
        }
        return this.matchPaths(this.excludes, classFile);
    }

    private boolean matchPaths(Set patterns, String classFile) {
        for (String pattern : patterns) {
            if (!SelectorUtils.matchPath((String)pattern, (String)classFile)) continue;
            return true;
        }
        return false;
    }
}

