/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.uberize.transformer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.fusesource.mvnplugins.uberize.DefaultUberizer;
import org.fusesource.mvnplugins.uberize.Transformer;
import org.fusesource.mvnplugins.uberize.UberEntry;
import org.fusesource.mvnplugins.uberize.Uberizer;
import org.fusesource.mvnplugins.uberize.relocation.PackageRelocation;
import org.fusesource.mvnplugins.uberize.relocation.Relocator;
import org.fusesource.mvnplugins.uberize.relocation.SimpleRelocator;
import org.fusesource.mvnplugins.uberize.transformer.Resources;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassShader
implements Transformer {
    public PackageRelocation[] relocations;
    public Resources resources;

    private List<Relocator> getRelocators() {
        ArrayList<Relocator> relocators = new ArrayList<Relocator>();
        if (this.relocations == null) {
            return relocators;
        }
        for (int i = 0; i < this.relocations.length; ++i) {
            PackageRelocation r = this.relocations[i];
            relocators.add(new SimpleRelocator(r.getPattern(), r.getShadedPattern(), r.getExcludes()));
        }
        return relocators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Uberizer uberizer, File workDir, TreeMap<String, UberEntry> nodes) throws IOException {
        List<Relocator> relocators = this.getRelocators();
        if (relocators.isEmpty()) {
            return;
        }
        HashMap<String, String> relocatedClasses = uberizer.getClassRelocations();
        RelocatorRemapper remapper = new RelocatorRemapper(relocators);
        for (UberEntry node : new ArrayList<UberEntry>(nodes.values())) {
            byte[] modifiedClass;
            String path;
            if (node.getSources().isEmpty() || !(path = node.getPath()).endsWith(".class")) continue;
            String classPath = path.substring(0, path.indexOf(46));
            String remappedPath = remapper.map(classPath) + ".class";
            File file = uberizer.pickOneSource(nodes, node);
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                ClassReader cr = new ClassReader((InputStream)fileInputStream);
                ClassWriter cw = new ClassWriter(cr, 0);
                RemappingClassAdapter cv = new RemappingClassAdapter((ClassVisitor)cw, (Remapper)remapper);
                cr.accept((ClassVisitor)cv, 8);
                modifiedClass = cw.toByteArray();
            }
            finally {
                IOUtil.close((InputStream)fileInputStream);
            }
            String className = classPath.replace('/', '.');
            String mappedClassName = this.mapClassName(relocators, className);
            if (mappedClassName != className) {
                relocatedClasses.put(className, mappedClassName);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(modifiedClass);
            File classFile = DefaultUberizer.writeFile(workDir, remappedPath, byteArrayInputStream);
            nodes.remove(path);
            UberEntry update = new UberEntry(remappedPath, node).addSource(classFile);
            nodes.put(update.getPath(), update);
        }
        if (this.resources != null && !relocatedClasses.isEmpty()) {
            String ncnc = "(\\A|\\z|[^\\p{L}\\p{Nd}\\.\\$\\_])";
            for (UberEntry node : new ArrayList<UberEntry>(nodes.values())) {
                String path = node.getPath();
                if (!this.resources.matches(path) || path.endsWith(".class")) continue;
                File file = uberizer.pickOneSource(nodes, node);
                String content = FileUtils.fileRead((File)file);
                for (Map.Entry entry : relocatedClasses.entrySet()) {
                    String regex = "(\\A|\\z|[^\\p{L}\\p{Nd}\\.\\$\\_])" + Pattern.quote((String)entry.getKey()) + "(\\A|\\z|[^\\p{L}\\p{Nd}\\.\\$\\_])";
                    String value = ((String)entry.getValue()).replaceAll("\\$", "\\\\\\$");
                    content = content.replaceAll(regex, "$1" + value + "$2");
                }
                File udpateFile = DefaultUberizer.prepareFile(workDir, node.getPath());
                FileUtils.fileWrite((String)udpateFile.getPath(), (String)content);
                UberEntry uberEntry = new UberEntry(node).addSource(udpateFile);
                nodes.put(node.getPath(), uberEntry);
            }
        }
    }

    public String mapClassName(List<Relocator> relocators, String name) {
        String value = name;
        for (Relocator r : relocators) {
            if (!r.canRelocateClass(name)) continue;
            value = r.relocateClass(name);
            break;
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RelocatorRemapper
    extends Remapper {
        List<Relocator> relocators;

        public RelocatorRemapper(List<Relocator> relocators) {
            this.relocators = relocators;
        }

        public boolean hasRelocators() {
            return !this.relocators.isEmpty();
        }

        public Object mapValue(Object object) {
            if (object instanceof String) {
                String name;
                String value = name = (String)object;
                for (Relocator r : this.relocators) {
                    if (r.canRelocateClass(name)) {
                        value = r.relocateClass(name);
                        break;
                    }
                    if (r.canRelocatePath(name)) {
                        value = r.relocatePath(name);
                        break;
                    }
                    if (name.length() <= 0 || name.charAt(0) != '[') continue;
                    int count = 0;
                    while (name.length() > 0 && name.charAt(0) == '[') {
                        name = name.substring(1);
                        ++count;
                    }
                    if (name.length() <= 0 || name.charAt(0) != 'L' || name.charAt(name.length() - 1) != ';') continue;
                    if (r.canRelocatePath(name = name.substring(1, name.length() - 1))) {
                        value = 'L' + r.relocatePath(name) + ';';
                        while (count > 0) {
                            value = '[' + value;
                            --count;
                        }
                    } else {
                        if (!r.canRelocateClass(name)) continue;
                        value = 'L' + r.relocateClass(name) + ';';
                        while (count > 0) {
                            value = '[' + value;
                            --count;
                        }
                    }
                    break;
                }
                return value;
            }
            return super.mapValue(object);
        }

        public String map(String name) {
            String value = name;
            for (Relocator r : this.relocators) {
                if (!r.canRelocatePath(name)) continue;
                value = r.relocatePath(name);
                break;
            }
            return value;
        }
    }
}

