/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.uberize.transformer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.codehaus.plexus.util.IOUtil;
import org.fusesource.mvnplugins.uberize.DefaultUberizer;
import org.fusesource.mvnplugins.uberize.Transformer;
import org.fusesource.mvnplugins.uberize.UberEntry;
import org.fusesource.mvnplugins.uberize.Uberizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestEditor
implements Transformer {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private String mainClass;
    private Map manifestEntries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Uberizer uberizer, File workDir, TreeMap<String, UberEntry> uberEntries) throws IOException {
        Manifest manifest;
        UberEntry uberEntry = uberEntries.get(MANIFEST_PATH);
        if (uberEntry != null && uberEntry.getSources().size() > 0) {
            FileInputStream is = new FileInputStream(uberEntry.getSources().get(0));
            try {
                manifest = new Manifest(is);
            }
            finally {
                IOUtil.close((InputStream)is);
            }
        } else {
            manifest = new Manifest();
        }
        Attributes attributes = manifest.getMainAttributes();
        if (this.mainClass != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (this.manifestEntries != null) {
            for (String key : this.manifestEntries.keySet()) {
                attributes.put(new Attributes.Name(key), this.manifestEntries.get(key));
            }
        }
        File targetFile = DefaultUberizer.prepareFile(workDir, MANIFEST_PATH);
        FileOutputStream os = new FileOutputStream(targetFile);
        try {
            manifest.write(os);
        }
        finally {
            IOUtil.close((OutputStream)os);
        }
        UberEntry modEntry = new UberEntry(MANIFEST_PATH, uberEntry).addSource(targetFile);
        uberEntries.put(MANIFEST_PATH, modEntry);
    }
}

