/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.client;

import java.io.IOException;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.stomp.client.FutureConnection;
import org.fusesource.stomp.codec.StompFrame;

public class BlockingConnection {
    private final FutureConnection connection;

    BlockingConnection(FutureConnection connection) {
        this.connection = connection;
    }

    public void close() throws IOException {
        try {
            this.connection.close().await();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public AsciiBuffer nextId() {
        return this.connection.nextId();
    }

    public AsciiBuffer nextId(String prefix) {
        return this.connection.nextId(prefix);
    }

    public StompFrame request(StompFrame frame) throws IOException {
        try {
            return this.connection.request(frame).await();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void send(StompFrame frame) throws IOException {
        try {
            this.connection.send(frame).await();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public StompFrame receive() throws IOException {
        try {
            return this.connection.receive().await();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public StompFrame connectedFrame() {
        return this.connection.connectedFrame();
    }

    public void resume() {
        this.connection.resume();
    }

    public void suspend() {
        this.connection.suspend();
    }
}

