/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.gaul.modernizer_maven_plugin.Utils;
import org.gaul.modernizer_maven_plugin.Violation;
import org.gaul.modernizer_maven_plugin.ViolationOccurrence;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

final class ModernizerClassVisitor
extends ClassVisitor {
    private final long javaVersion;
    private final Map<String, Violation> violations;
    private final Collection<String> exclusions;
    private final Collection<String> ignorePackages;
    private final Collection<ViolationOccurrence> occurrences = new ArrayList<ViolationOccurrence>();
    private String packageName;

    ModernizerClassVisitor(long javaVersion, Map<String, Violation> violations, Collection<String> exclusions, Collection<String> ignorePackages) {
        super(327680);
        Utils.checkArgument(javaVersion >= 0L);
        this.javaVersion = javaVersion;
        this.violations = Utils.checkNotNull(violations);
        this.exclusions = Utils.checkNotNull(exclusions);
        this.ignorePackages = Utils.checkNotNull(ignorePackages);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.packageName = name.contains("/") ? name.substring(0, name.lastIndexOf(47)).replace('/', '.') : "";
        for (String itr : interfaces) {
            Violation violation = this.violations.get(itr);
            this.checkToken(itr, violation, name, -1);
        }
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDescriptor, String methodSignature, String[] exceptions) {
        MethodVisitor base = super.visitMethod(access, methodName, methodDescriptor, methodSignature, exceptions);
        MethodVisitor origVisitor = new MethodVisitor(327680, base){};
        InstructionAdapter adapter = new InstructionAdapter(327680, origVisitor){
            private int lineNumber;
            {
                this.lineNumber = -1;
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                this.visitFieldOrMethod(owner, name, desc);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
                if (name.equals("<init>")) {
                    name = "\"<init>\"";
                }
                this.visitFieldOrMethod(owner, name, desc);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                String name = Type.getType((String)desc).getInternalName();
                Violation violation = (Violation)ModernizerClassVisitor.this.violations.get(name);
                ModernizerClassVisitor.this.checkToken(name, violation, name, this.lineNumber);
                return super.visitAnnotation(desc, visible);
            }

            private void visitFieldOrMethod(String owner, String name, String desc) {
                String token = owner + "." + name + ":" + desc;
                Violation violation = (Violation)ModernizerClassVisitor.this.violations.get(token);
                ModernizerClassVisitor.this.checkToken(token, violation, name, this.lineNumber);
            }

            public void visitLineNumber(int lineNumber, Label start) {
                this.lineNumber = lineNumber;
            }
        };
        return adapter;
    }

    private void checkToken(String token, Violation violation, String name, int lineNumber) {
        if (violation != null && !this.exclusions.contains(token) && this.javaVersion >= (long)violation.getVersion() && !this.ignorePackages.contains(this.packageName)) {
            for (String prefix : this.ignorePackages) {
                if (!this.packageName.startsWith(prefix + ".")) continue;
                return;
            }
            this.occurrences.add(new ViolationOccurrence(name, lineNumber, violation));
        }
    }

    Collection<ViolationOccurrence> getOccurrences() {
        return this.occurrences;
    }
}

