/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin.output;

import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.gaul.modernizer_maven_plugin.output.OutputEntry;
import org.gaul.modernizer_maven_plugin.output.Outputer;

public final class LoggerOutputer
implements Outputer {
    private final Log log;
    private final String level;

    public LoggerOutputer(Log log, String level) {
        this.log = log;
        this.level = level;
    }

    @Override
    public void output(List<OutputEntry> entries) {
        for (OutputEntry entry : entries) {
            String message = entry.getFileName() + ":" + entry.getOccurrence().getLineNumber() + ": " + entry.getOccurrence().getViolation().getComment();
            if (this.level.equals("error")) {
                this.log.error((CharSequence)message);
                continue;
            }
            if (this.level.equals("warn")) {
                this.log.warn((CharSequence)message);
                continue;
            }
            if (this.level.equals("info")) {
                this.log.info((CharSequence)message);
                continue;
            }
            if (this.level.equals("debug")) {
                this.log.debug((CharSequence)message);
                continue;
            }
            throw new IllegalStateException("unexpected log level, was: " + this.level);
        }
    }
}

