/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.store;

import com.sun.enterprise.security.store.PasswordAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class IdentityManager {
    public static final String PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY = "com.sun.aas.promptForIdentity";
    private static final String USER_ALIAS = "admin-user";
    private static final String PASSWORD_ALIAS = "admin-password";
    private static final String MASTER_PASSWORD_ALIAS = "master-password";
    private static final String IDENTITY_STORE_FILE_NAME = ".identity";
    private static String _user = null;
    private static String _password = null;
    private static String _masterPassword = null;
    private static Hashtable _htIdentity = new Hashtable();
    private static boolean bDebug = false;
    private static boolean _keystorePropertyWasSet = true;
    private static boolean _truststorePropertyWasSet = true;
    private static boolean _nssDbPasswordPropertyWasSet = true;

    private IdentityManager() {
    }

    public static String[] getIdentityArray() {
        ArrayList<String> ar = new ArrayList<String>();
        ar.add(IdentityManager.getUser());
        ar.add(IdentityManager.getPassword());
        ar.add(IdentityManager.getMasterPassword());
        Iterator it = _htIdentity.keySet().iterator();
        String key = null;
        while (it.hasNext()) {
            key = (String)it.next();
            ar.add(key + "=" + (String)_htIdentity.get(key));
        }
        String[] identity = new String[ar.size()];
        identity = ar.toArray(identity);
        return identity;
    }

    public static void populateFromInputStreamQuietly() throws IOException {
        IdentityManager.populateFromInputStream(System.in, true);
    }

    public static void populateFromInputStream() throws IOException {
        IdentityManager.populateFromInputStream(System.in);
    }

    public static void populateFromInputStream(InputStream in) throws IOException {
        IdentityManager.populateFromInputStream(in, false);
    }

    public static void populateFromInputStream(InputStream in, boolean quiet) throws IOException {
        if (bDebug) {
            System.out.println("IM seeing if need to read in security properties from stdin");
        }
        if (in == null || System.getProperty(PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY) == null) {
            return;
        }
        BufferedReader br = null;
        if (bDebug) {
            System.out.println("IM attempting to read from inputstream");
        }
        br = new BufferedReader(new InputStreamReader(System.in));
        String sxLine = null;
        int cnt = 0;
        boolean ipos = false;
        if (!quiet) {
            System.out.println("Enter Admin User:");
        }
        while ((sxLine = br.readLine()) != null) {
            if (bDebug) {
                System.out.println("IM Number read - Reading Line:" + cnt + " - " + sxLine);
            }
            switch (cnt) {
                case 0: {
                    IdentityManager.setUser(sxLine);
                    if (quiet) break;
                    System.out.println("Enter Admin Password:");
                    break;
                }
                case 1: {
                    IdentityManager.setPassword(sxLine);
                    if (quiet) break;
                    System.out.println("Enter Master Password:");
                    break;
                }
                case 2: {
                    IdentityManager.setMasterPassword(sxLine);
                    if (quiet) break;
                    System.out.println("Enter Other Password Information (or ctrl-D or ctrl-Z):");
                    break;
                }
                default: {
                    IdentityManager.putTokenizedString(sxLine);
                    if (quiet) break;
                    System.out.println("Enter Other Password Information (or ctrl-D or ctrl-Z):");
                }
            }
            ++cnt;
        }
    }

    public static void writeToOutputStream(OutputStream out) {
        if (out == null) {
            return;
        }
        PrintWriter writer = null;
        writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out)));
        if (bDebug) {
            System.out.println("Writing to OutputStream: " + IdentityManager.getFormatedContents());
        }
        writer.println(IdentityManager.getUser());
        writer.println(IdentityManager.getPassword());
        writer.println(IdentityManager.getMasterPassword());
        Iterator it = _htIdentity.keySet().iterator();
        String key = null;
        while (it.hasNext()) {
            key = (String)it.next();
            writer.println(key + "=" + (String)_htIdentity.get(key));
        }
        writer.flush();
        writer.close();
    }

    public static String getFormatedContents() {
        StringBuffer sb = new StringBuffer("IdentityManager Data: User:" + IdentityManager.getUser());
        if (bDebug) {
            sb.append(", ");
            sb.append("Password:" + IdentityManager.getPassword() + ", ");
            sb.append("MasterPassword:" + IdentityManager.getMasterPassword() + ", ");
            Iterator it = _htIdentity.keySet().iterator();
            String key = null;
            while (it.hasNext()) {
                key = (String)it.next();
                sb.append(key + ":" + (String)_htIdentity.get(key) + ", ");
            }
        }
        return sb.toString();
    }

    public static void setUser(String userx) {
        _user = userx;
    }

    public static String getUser() {
        return _user;
    }

    public static void setPassword(String passwordx) {
        _password = passwordx;
    }

    public static String getPassword() {
        return _password;
    }

    public static void setMasterPassword(String masterPasswordx) {
        _masterPassword = masterPasswordx;
        if (!(System.getProperty("javax.net.ssl.keyStore") == null || _keystorePropertyWasSet && System.getProperty("javax.net.ssl.keyStorePassword") != null)) {
            System.setProperty("javax.net.ssl.keyStorePassword", IdentityManager.getMasterPassword());
            _keystorePropertyWasSet = false;
        }
        if (!(System.getProperty("javax.net.ssl.trustStore") == null || _truststorePropertyWasSet && System.getProperty("javax.net.ssl.trustStorePassword") != null)) {
            System.setProperty("javax.net.ssl.trustStorePassword", IdentityManager.getMasterPassword());
            _truststorePropertyWasSet = false;
        }
        if (!(System.getProperty("com.sun.appserv.nss.db") == null || _nssDbPasswordPropertyWasSet && System.getProperty("com.sun.appserv.nss.db.password") != null)) {
            System.setProperty("com.sun.appserv.nss.db.password", IdentityManager.getMasterPassword());
            _nssDbPasswordPropertyWasSet = false;
        }
    }

    public static String getMasterPassword() {
        return _masterPassword;
    }

    public static void putTokenizedString(String sxToken) {
        int ipos = sxToken.indexOf("=");
        if (ipos > 0) {
            IdentityManager.put(sxToken.substring(0, ipos), sxToken.substring(ipos + 1));
        }
    }

    public static void put(String key, String value) {
        _htIdentity.put(key, value);
    }

    public static String get(String key) {
        return (String)_htIdentity.get(key);
    }

    public static void addToMap(HashMap map) {
        Iterator it = map.keySet().iterator();
        String key = null;
        while (it.hasNext()) {
            key = (String)it.next();
            IdentityManager.put(key, (String)map.get(key));
        }
    }

    public static Map getMap() {
        HashMap<String, String> hm = new HashMap<String, String>();
        Iterator it = _htIdentity.keySet().iterator();
        String key = null;
        while (it.hasNext()) {
            key = (String)it.next();
            hm.put(new String(key), new String((String)_htIdentity.get(key)));
        }
        return hm;
    }

    public static void createIdentityStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException {
        Properties aliasPasswordProps = new Properties();
        aliasPasswordProps.setProperty(USER_ALIAS, IdentityManager.getUser());
        aliasPasswordProps.setProperty(PASSWORD_ALIAS, IdentityManager.getPassword());
        aliasPasswordProps.setProperty(MASTER_PASSWORD_ALIAS, IdentityManager.getMasterPassword());
        File instanceRoot = new File(System.getProperty("com.sun.aas.instanceRoot"), IDENTITY_STORE_FILE_NAME);
        PasswordAdapter p = new PasswordAdapter(instanceRoot.getAbsolutePath(), IdentityManager.getMasterPasswordPassword());
        Iterator<Object> iter = aliasPasswordProps.keySet().iterator();
        String alias = null;
        String pass = null;
        while (iter.hasNext()) {
            alias = (String)iter.next();
            pass = aliasPasswordProps.getProperty(alias);
            p.setPasswordForAlias(alias, pass.getBytes());
        }
    }

    public static void readIdentityStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException {
        File instanceRoot = new File(System.getProperty("com.sun.aas.instanceRoot"), IDENTITY_STORE_FILE_NAME);
        System.out.println("****** READING IDENTITY FROM ====>" + instanceRoot.getAbsolutePath());
        if (instanceRoot.exists()) {
            PasswordAdapter p = new PasswordAdapter(instanceRoot.getAbsolutePath(), IdentityManager.getMasterPasswordPassword());
            IdentityManager.setUser(p.getPasswordForAlias(USER_ALIAS));
            IdentityManager.setPassword(p.getPasswordForAlias(PASSWORD_ALIAS));
            IdentityManager.setMasterPassword(p.getPasswordForAlias(MASTER_PASSWORD_ALIAS));
        }
    }

    public static void deleteIdentityStore() {
        File instanceRoot = new File(System.getProperty("com.sun.aas.instanceRoot"), IDENTITY_STORE_FILE_NAME);
        instanceRoot.delete();
    }

    private static char[] getMasterPasswordPassword() {
        return MASTER_PASSWORD_ALIAS.toCharArray();
    }
}

