/*
 * Decompiled with CFR 0.152.
 */
package com.sun.logging;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogDomains {
    public static final String DOMAIN_ROOT = "javax.";
    public static final String PACKAGE_ROOT = "com.sun.logging.";
    public static final String RESOURCE_BUNDLE = "LogStrings";
    public static final String TOOLS_LOGGER = "javax.enterprise.system.tools";
    public static final String EJB_LOGGER = "javax.enterprise.system.container.ejb";
    public static final String JAVAMAIL_LOGGER = "javax.enterprise.resource.javamail";
    public static final String JMS_LOGGER = "javax.enterprise.resource.jms";
    public static final String WEB_LOGGER = "javax.enterprise.system.container.web";
    public static final String CMP_LOGGER = "javax.enterprise.system.container.cmp";
    public static final String JDO_LOGGER = "javax.enterprise.resource.jdo";
    public static final String ACC_LOGGER = "javax.enterprise.system.container.appclient";
    public static final String MDB_LOGGER = "javax.enterprise.system.container.ejb.mdb";
    public static final String SECURITY_LOGGER = "javax.enterprise.system.core.security";
    public static final String TRANSACTION_LOGGER = "javax.enterprise.system.core.transaction";
    public static final String CORBA_LOGGER = "javax.enterprise.resource.corba";
    public static final String ROOT_LOGGER = "javax.enterprise";
    public static final String UTIL_LOGGER = "javax.enterprise.system.util";
    public static final String NAMING_LOGGER = "javax.enterprise.system.core.naming";
    public static final String JNDI_LOGGER = "javax.enterprise.system.core.naming";
    public static final String APPVERIFY_LOGGER = "javax.enterprise.system.tools.verifier";
    public static final String ACTIVATION_LOGGER = "javax.enterprise.system.activation";
    public static final String JTA_LOGGER = "javax.enterprise.resource.jta";
    public static final String RSR_LOGGER = "javax.enterprise.resource.resourceadapter";
    public static final String DPL_LOGGER = "javax.enterprise.system.tools.deployment";
    public static final String DPLAUDIT_LOGGER = "javax.enterprise.system.tools.deployment.audit";
    public static final String DIAGNOSTICS_LOGGER = "javax.enterprise.system.tools.diagnostics";
    public static final String JAXRPC_LOGGER = "javax.enterprise.system.webservices.rpc";
    public static final String JAXR_LOGGER = "javax.enterprise.system.webservices.registry";
    public static final String SAAJ_LOGGER = "javax.enterprise.system.webservices.saaj";
    public static final String SELF_MANAGEMENT_LOGGER = "javax.enterprise.system.core.selfmanagement";
    public static final String ADMIN_LOGGER = "javax.enterprise.system.tools.admin";
    public static final String SERVER_LOGGER = "javax.enterprise.system";
    public static final String CORE_LOGGER = "javax.enterprise.system.core";
    public static final String LOADER_LOGGER = "javax.enterprise.system.core.classloading";
    public static final String CONFIG_LOGGER = "javax.enterprise.system.core.config";
    public static final String PROCESS_LAUNCHER_LOGGER = "javax.enterprise.tools.launcher";
    public static final String GMS_LOGGER = "javax.ee.enterprise.system.gms";
    public static final String AMX_LOGGER = "javax.enterprise.system.AMX";
    public static final String SERVICES_LOGGER = "javax.enterprise.system.core.services";

    private static String getLoggerResourceBundleName(String loggerName) {
        String result = loggerName + "." + RESOURCE_BUNDLE;
        return result.replaceFirst(DOMAIN_ROOT, PACKAGE_ROOT);
    }

    public static Logger getLogger(final Class clazz, final String name) {
        final ClassLoader cloader = clazz.getClassLoader();
        Logger l = LogManager.getLogManager().getLogger(name);
        if (l == null) {
            l = new Logger(name, null){

                public ResourceBundle getResourceBundle() {
                    try {
                        return ResourceBundle.getBundle(LogDomains.getLoggerResourceBundleName(name), Locale.getDefault(), cloader);
                    }
                    catch (MissingResourceException e) {
                        String root = clazz.getPackage().getName();
                        try {
                            return ResourceBundle.getBundle(root + "." + LogDomains.RESOURCE_BUNDLE, Locale.getDefault(), cloader);
                        }
                        catch (MissingResourceException me) {
                            String p = root;
                            while (p != null) {
                                try {
                                    int i = p.lastIndexOf(".");
                                    if (i != -1) {
                                        p = p.substring(0, i);
                                        return ResourceBundle.getBundle(p + "." + LogDomains.RESOURCE_BUNDLE, Locale.getDefault(), cloader);
                                    }
                                    p = null;
                                }
                                catch (MissingResourceException mre) {}
                            }
                            try {
                                return ResourceBundle.getBundle(LogDomains.getLoggerResourceBundleName(name), Locale.getDefault(), LogDomains.class.getClassLoader());
                            }
                            catch (MissingResourceException missingResourceException) {
                                System.out.println("class name that failed " + clazz.getName());
                                throw e;
                            }
                        }
                    }
                }
            };
            if (!LogManager.getLogManager().addLogger(l)) {
                Logger existing = LogManager.getLogManager().getLogger(name);
                if (existing == null) {
                    LogManager.getLogManager().addLogger(l);
                } else {
                    l = existing;
                }
            }
        }
        return l;
    }
}

