/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.FieldInfo;
import com.sun.enterprise.util.FieldInfoVector;
import com.sun.enterprise.util.ObjectAnalyzerException;
import com.sun.enterprise.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;

public class ObjectAnalyzer {
    private static final String fatal = "Fatal Error in ObjectAnalyzer.toString():  ";
    private static boolean useShortClassNames_ = true;
    private static Method setAccessibleMethod;

    public static String getMethods(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return ObjectAnalyzer.getMethods(clazz, false);
        }
        catch (Exception e) {
            return "Error loading class: " + e.getMessage();
        }
    }

    public static String getMethods(Object obj) {
        return ObjectAnalyzer.getMethods(obj, false);
    }

    public static String getMethods(Object obj, boolean settersOnly) {
        try {
            Class clazz = ObjectAnalyzer.safeGetClass(obj);
            return ObjectAnalyzer.getMethods(clazz, settersOnly);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static String getMethods(Class clazz, boolean settersOnly) {
        String s = new String();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            boolean isSetter = m.getName().startsWith("set");
            if (settersOnly && !isSetter) continue;
            s = s + m.toString() + '\n';
        }
        return s;
    }

    public static String getSetters(Object obj) {
        return ObjectAnalyzer.getMethods(obj, true);
    }

    public static String getSetters(Class clazz) {
        return ObjectAnalyzer.getMethods(clazz, true);
    }

    public static String toString(Object obj) {
        return ObjectAnalyzer.toString(obj, false);
    }

    public static String toStringWithSuper(Object obj) {
        return ObjectAnalyzer.toString(obj, true);
    }

    public static boolean equals(Object a, Object b) {
        Class<?> cl = a.getClass();
        if (!cl.equals(b.getClass())) {
            return false;
        }
        Field[] fields = cl.getDeclaredFields();
        ObjectAnalyzer.setAccessible(fields);
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            try {
                if (f.get(a).equals(f.get(b))) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
        return true;
    }

    public static void useShortClassNames() {
        useShortClassNames_ = true;
    }

    public static void useLongClassNames() {
        useShortClassNames_ = false;
    }

    private static String toString(Object obj, boolean doSuperClasses) {
        try {
            return ObjectAnalyzer.getFieldInfo(obj, doSuperClasses).toString();
        }
        catch (ObjectAnalyzerException e) {
            return e.getMessage();
        }
    }

    private static Class safeGetClass(Object obj) throws ObjectAnalyzerException {
        if (obj == null) {
            throw new ObjectAnalyzerException("Fatal Error in ObjectAnalyzer.toString():  null Object parameter");
        }
        if (!(obj instanceof Object)) {
            throw new ObjectAnalyzerException("Fatal Error in ObjectAnalyzer.toString():  Object parameter is not really a java.lang.Object");
        }
        Class<?> cl = obj.getClass();
        if (cl == null) {
            throw new ObjectAnalyzerException("Fatal Error in ObjectAnalyzer.toString():  getClass() on parameter Object returned null");
        }
        return cl;
    }

    private static Class safeGetSuperclass(Class cl) throws ObjectAnalyzerException {
        Class sc = cl.getSuperclass();
        if (sc == null) {
            throw new ObjectAnalyzerException("getSuperclass() on parameter Object returned null");
        }
        return sc;
    }

    private static FieldInfoVector getFieldInfo(Object obj, boolean doSuperClasses) throws ObjectAnalyzerException {
        FieldInfoVector fiv = new FieldInfoVector();
        Class cl = ObjectAnalyzer.safeGetClass(obj);
        if (!doSuperClasses) {
            ObjectAnalyzer.getFieldInfo(cl, obj, fiv);
            return fiv;
        }
        Class theClass = cl;
        while (theClass != null && !theClass.equals(Object.class)) {
            ObjectAnalyzer.getFieldInfo(theClass, obj, fiv);
            theClass = ObjectAnalyzer.safeGetSuperclass(theClass);
        }
        return fiv;
    }

    private static void getFieldInfo(Class cl, Object obj, FieldInfoVector fiv) throws ObjectAnalyzerException {
        Field[] fields = null;
        try {
            fields = cl.getDeclaredFields();
        }
        catch (SecurityException e) {
            throw new ObjectAnalyzerException("got a SecurityException when calling getDeclaredFields() on " + cl.getName());
        }
        if (fields == null) {
            throw new ObjectAnalyzerException("calling getDeclaredFields() on " + cl.getName() + " returned null");
        }
        ObjectAnalyzer.setAccessible(fields);
        for (int i = 0; i < fields.length; ++i) {
            String sval;
            Field f = fields[i];
            String modifiers = Modifier.toString(f.getModifiers());
            String className = cl.getName();
            if (useShortClassNames_) {
                className = StringUtils.toShortClassName(className);
            }
            if (modifiers.length() <= 0) {
                modifiers = "(package)";
            }
            try {
                Object val = f.get(obj);
                sval = val == null ? "<null>" : val.toString();
            }
            catch (IllegalAccessException e) {
                sval = "<IllegalAccessException>";
            }
            fiv.addElement(new FieldInfo(className, f, sval, modifiers));
        }
    }

    private static void setAccessible(Field[] fields) {
        if (setAccessibleMethod == null) {
            return;
        }
        try {
            Boolean b = true;
            setAccessibleMethod.invoke(null, fields, b);
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().warning("Got an exception invoking setAccessible: " + e);
        }
    }

    private static void setupSetAccessibleMethod() {
        Class<?> AO;
        setAccessibleMethod = null;
        try {
            AO = Class.forName("java.lang.reflect.AccessibleObject");
        }
        catch (ClassNotFoundException e) {
            Logger.getAnonymousLogger().info("Can't find java.lang.reflect.AccessibleObject -- thus I can't show any private or protected variable values.  This must be pre JDK 1.2.x");
            return;
        }
        Method[] methods = AO.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals("setAccessible") || m.getParameterTypes().length != 2) continue;
            Logger.getAnonymousLogger().fine("Found setAccessible: " + m);
            setAccessibleMethod = m;
            break;
        }
    }

    public static void main(String[] args) {
        String s = new String("Hello!");
        System.out.println("Regular: \n" + ObjectAnalyzer.toString(s) + "\n\n");
        System.out.println("Super: \n" + ObjectAnalyzer.toStringWithSuper(s) + "\n\n");
    }

    static {
        ObjectAnalyzer.setupSetAccessibleMethod();
    }
}

