/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright (c) 1997-2011 Oracle and/or its affiliates. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * 
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 * 
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.corba.ee.spi.orbutil.tf;

import com.sun.corba.ee.spi.orbutil.logex.Chain;
import com.sun.corba.ee.spi.orbutil.logex.ExceptionWrapper;
import com.sun.corba.ee.spi.orbutil.logex.Log;
import com.sun.corba.ee.spi.orbutil.logex.LogLevel;
import com.sun.corba.ee.spi.orbutil.logex.Message;
import com.sun.corba.ee.spi.orbutil.logex.WrapperGenerator;
import com.sun.corba.ee.spi.orbutil.logex.stdcorba.StandardLogger;

/** Exception wrapper class.  The logex WrapperGenerator uses this interface
 * to generate an implementation which returns the appropriate exception, and
 * generates a log report when the method is called.  This is used for all
 * implementation classes in this package.
 *
 * The exception IDs are allocated in blocks of EXCEPTIONS_PER_CLASS, which is
 * a lot more than is needed, but we have 32 bits for IDs, and multiples of
 * a suitably chosen EXCEPTIONS_PER_CLASS (like 100 here) are easy to read in
 * error messages.
 *
 * @author ken
 */
@ExceptionWrapper( idPrefix="ORBTF" )
public interface Exceptions {
    Exceptions self = WrapperGenerator.makeWrapper(
        Exceptions.class, StandardLogger.self ) ;

    // Allow 100 exceptions per class
    int EXCEPTIONS_PER_CLASS = 100 ;

// MethodMonitorRegistry
    int MMR_START = 1 ;

    @Message( "Error in setting field ${0} in class ${1}" ) 
    @Log( id = MMR_START + 0 ) 
    void fieldSettingError( @Chain Exception exc, Class cls, String fld ) ;

    @Message( "Error in registerAnnotationFile for file ${0}" ) 
    @Log( id = MMR_START + 1 ) 
    void exceptionInRegisterAnnotationFile( @Chain Exception exc, String fname ) ;

    @Message( "Error in registerClass for class ${0}" ) 
    @Log( id = MMR_START + 2 ) 
    void exceptionInRegisterClass( @Chain Exception exc, Class<?> cls ) ;
}
