/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployapi;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.glassfish.deployapi.SunDeploymentManager;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.glassfish.deployment.common.DeploymentUtils;

public class SunDeploymentFactory
implements DeploymentFactory {
    private static LocalStringManagerImpl xlocalStrings = new LocalStringManagerImpl(SunDeploymentFactory.class);
    private static String DMGR_NOT_CONNECTED = xlocalStrings.getLocalString("enterprise.deployapi.spi.DMgrnotconnected", "Deployment Manager is not connected to J2EE Resources");
    private static final String PE_BETA_URISTRING = "deployer:Sun:S1AS::";
    private static final String DEFAULT_URISTRING = "deployer:Sun:AppServer::";
    private static final String HTTPS = "https";
    private static final String URI_SEPARATOR = ":";
    private static final String LOCAL_HOST = "localhost";
    private static final int HOST_PORT = 4848;
    private static final String[] supportedURIs = new String[]{"deployer:Sun:S1AS::", "deployer:Sun:AppServer::"};
    private static Hashtable connectedDeploymentManagers;
    private static Hashtable disconnectedDeploymentManagers;
    private static final String HTTPS_PROTOCOL = "s1ashttps";
    private static final String HTTP_PROTOCOL = "s1ashttp";
    private static final Logger sLogger;

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        if (this.handlesURI(uri)) {
            ServerConnectionIdentifier hostInfo = null;
            try {
                hostInfo = this.parseURIForHostInfo(uri);
            }
            catch (Exception ex) {
                DeploymentManagerCreationException e = new DeploymentManagerCreationException(xlocalStrings.getLocalString("enterprise.deployapi.spi.wronghostidentifier", "Wrong host identifier in uri {0} ", new Object[]{uri}));
                e.initCause((Throwable)ex);
                throw e;
            }
            try {
                hostInfo.setUserName(username);
                hostInfo.setPassword(password);
                SunDeploymentManager answer = null;
                answer = new SunDeploymentManager(hostInfo);
                return answer;
            }
            catch (Throwable t) {
                DeploymentManagerCreationException e = new DeploymentManagerCreationException(xlocalStrings.getLocalString("enterprise.deployapi.spi.exceptionwhileconnecting", "Exception while connecting to {0} : {1}", new Object[]{uri, t.getMessage()}));
                e.initCause(t);
                throw e;
            }
        }
        return null;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (this.handlesURI(uri)) {
            return new SunDeploymentManager();
        }
        return null;
    }

    public String getDisplayName() {
        return xlocalStrings.getLocalString("enterprise.deployapi.spi.DisplayName", "Sun Java System Application Server");
    }

    public String getProductVersion() {
        return xlocalStrings.getLocalString("enterprise.deployapi.spi.ProductVersion", "9.0");
    }

    public boolean handlesURI(String uri) {
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine("handlesURI: URI [" + uri + "]");
        }
        if (uri != null) {
            try {
                return this.parseURIForHostInfo(uri) != null;
            }
            catch (Exception ex) {
                sLogger.log(Level.SEVERE, "enterprise.deployment.backend.deplyomentManagerLoadFailure", new Object[]{uri});
            }
        }
        return false;
    }

    public ServerConnectionIdentifier parseURIForHostInfo(String uri) throws Exception {
        String targetURI = null;
        for (int i = 0; i < supportedURIs.length; ++i) {
            if (uri.indexOf(supportedURIs[i]) != 0) continue;
            targetURI = supportedURIs[i];
        }
        if (targetURI == null) {
            throw new Exception(xlocalStrings.getLocalString("enterprise.deployapi.spi.invaliduri", "Invalid URI"));
        }
        ServerConnectionIdentifier sci = new ServerConnectionIdentifier();
        if (uri.length() == targetURI.length()) {
            sci.setHostName(LOCAL_HOST);
            sci.setHostPort(4848);
        } else {
            String reminder = uri.substring(targetURI.length());
            String[] splitted = reminder.split(URI_SEPARATOR);
            if (splitted.length < 2) {
                throw new Exception(xlocalStrings.getLocalString("enterprise.deployapi.spi.invaliduri", "Invalid URI"));
            }
            if ("".equals(splitted[0])) {
                sci.setHostName(LOCAL_HOST);
            } else {
                sci.setHostName(splitted[0]);
            }
            if ("".equals(splitted[1])) {
                sci.setHostPort(4848);
            } else {
                sci.setHostPort(Integer.parseInt(splitted[1]));
            }
            if (splitted.length > 2 && HTTPS.equals(splitted[2])) {
                sci.setSecure(true);
            }
        }
        return sci;
    }

    static {
        sLogger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");
    }
}

