/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryNode
extends DeploymentDescriptorNode {
    private QueryDescriptor descriptor = null;

    public QueryNode() {
        this.registerElementHandler(new XMLElement("query-method"), MethodNode.class, "setQueryMethodDescriptor");
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (QueryDescriptor)super.getDescriptor();
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("ejb-ql", "setQuery");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("result-type-mapping".equals(element.getQName())) {
            if ("Remote".equals(value)) {
                this.descriptor.setHasRemoteReturnTypeMapping();
            } else if ("Local".equals(value)) {
                this.descriptor.setHasLocalReturnTypeMapping();
            } else {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{((Descriptor)this.getParentNode().getDescriptor()).getName(), value});
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, QueryDescriptor descriptor) {
        Node queryNode = super.writeDescriptor(parent, nodeName, descriptor);
        this.writeLocalizedDescriptions(queryNode, descriptor);
        MethodNode methodNode = new MethodNode();
        methodNode.writeQueryMethodDescriptor(queryNode, "query-method", descriptor.getQueryMethodDescriptor());
        if (descriptor.getHasRemoteReturnTypeMapping()) {
            QueryNode.appendTextChild(queryNode, "result-type-mapping", "Remote");
        } else if (descriptor.getHasLocalReturnTypeMapping()) {
            QueryNode.appendTextChild(queryNode, "result-type-mapping", "Local");
        }
        String ejbqlText = descriptor.getIsEjbQl() ? descriptor.getQuery() : "";
        Element child = QueryNode.appendChild(queryNode, "ejb-ql");
        child.appendChild(QueryNode.getOwnerDocument(child).createTextNode(ejbqlText));
        return queryNode;
    }
}

