/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.maven.AbstractServerMojo;
import org.glassfish.maven.PluginUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployMojo
extends AbstractServerMojo {
    protected String name;
    protected String contextRoot;
    protected Boolean precompileJsp;
    protected String dbVendorName;
    protected Boolean createTables;
    protected String libraries;
    String buildDirectory;
    String baseDirectory;
    String fileName;
    protected String app;
    protected String[] deploymentParams;
    protected String[] undeploymentParams;

    @Override
    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    protected String[] getDeploymentParameters() {
        ArrayList<String> deployParams = new ArrayList<String>();
        this.set(deployParams, "--name", this.name);
        this.set(deployParams, "--force", "true");
        this.set(deployParams, "--contextroot", this.contextRoot);
        this.set(deployParams, "--precompilejsp", this.precompileJsp);
        this.set(deployParams, "--dbvendorname", this.dbVendorName);
        this.set(deployParams, "--createtables", this.createTables);
        this.set(deployParams, "--libraries", this.libraries);
        if (this.deploymentParams != null) {
            for (String p : this.deploymentParams) {
                deployParams.add(p);
            }
        }
        return deployParams.toArray(new String[0]);
    }

    protected String[] getUndeploymentParameters() {
        ArrayList<String> undeployParams = new ArrayList<String>();
        if (this.undeploymentParams != null) {
            for (String p : this.undeploymentParams) {
                undeployParams.add(p);
            }
        }
        return undeployParams.toArray(new String[0]);
    }

    void set(List<String> params, String paramName, Object paramValue) {
        if (paramValue != null && paramName != null) {
            params.add(paramName + "=" + paramValue.toString());
        }
    }

    protected String getApp() {
        if (this.app != null) {
            return new File(this.app).isAbsolute() ? this.app : this.baseDirectory + File.separator + this.app;
        }
        return this.buildDirectory + File.separator + this.fileName + ".war";
    }

    protected void doDeploy(String serverId, ClassLoader cl, Properties bootstrapProps, Properties glassfishProperties, File archive, String[] deploymentParams) throws Exception {
        Class<?> clazz = cl.loadClass(PluginUtil.class.getName());
        Method m = clazz.getMethod("doDeploy", String.class, ClassLoader.class, Properties.class, Properties.class, File.class, String[].class);
        m.invoke(null, serverId, cl, bootstrapProps, glassfishProperties, archive, deploymentParams);
    }

    protected void doUndeploy(String serverId, ClassLoader cl, Properties bootstrapProps, Properties glassfishProperties, String appName, String[] undeploymentParams) throws Exception {
        Class<?> clazz = cl.loadClass(PluginUtil.class.getName());
        Method m = clazz.getMethod("doUndeploy", String.class, ClassLoader.class, Properties.class, Properties.class, String.class, String[].class);
        m.invoke(null, serverId, cl, bootstrapProps, glassfishProperties, appName, undeploymentParams);
    }
}

