/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.glassfish.maven.AbstractDeployMojo;
import org.glassfish.maven.PluginUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunMojo
extends AbstractDeployMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Properties> commands = this.getAdminCommandConfigurations();
        try {
            String str;
            this.startGlassFish(this.serverID, this.getClassLoader(), this.getBootStrapProperties(), this.getGlassFishProperties());
            for (Properties command : commands) {
                this.runCommand(this.serverID, this.getClassLoader(), ((List)command.get("commands")).toArray(new String[0]));
            }
            do {
                List<Properties> deployments = this.getDeploymentConfigurations();
                for (Properties deployment : deployments) {
                    this.doDeploy(this.serverID, this.getClassLoader(), this.getBootStrapProperties(), this.getGlassFishProperties(), new File(this.getApp(deployment.getProperty("app"))), this.getDeploymentParameters(deployment));
                }
                System.out.println("Hit ENTER to redeploy, X to exit");
                str = new BufferedReader(new InputStreamReader(System.in)).readLine();
                for (Properties deployment : deployments) {
                    this.doUndeploy(this.serverID, this.getClassLoader(), this.getBootStrapProperties(), this.getGlassFishProperties(), deployment.getProperty("name"), new String[0]);
                }
            } while (!str.equalsIgnoreCase("X"));
            this.stopGlassFish(this.serverID, this.getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private List<Properties> getAdminCommandConfigurations() {
        ArrayList<Properties> deployments = new ArrayList<Properties>();
        Plugin embeddedPlugin = this.getPlugin("maven-embedded-glassfish-plugin");
        List<PluginExecution> deployGoals = this.getGoals(embeddedPlugin, "admin");
        for (PluginExecution pluginExecution : deployGoals) {
            Properties configurations = this.getConfigurations(pluginExecution, embeddedPlugin, "commands");
            deployments.add(configurations);
        }
        return deployments;
    }

    private List<Properties> getDeploymentConfigurations() {
        ArrayList<Properties> deployments = new ArrayList<Properties>();
        Plugin embeddedPlugin = this.getPlugin("maven-embedded-glassfish-plugin");
        List<PluginExecution> deployGoals = this.getGoals(embeddedPlugin, "deploy");
        for (PluginExecution pluginExecution : deployGoals) {
            Properties configurations = this.getConfigurations(pluginExecution, embeddedPlugin, "deploymentParams");
            deployments.add(configurations);
        }
        return deployments;
    }

    private Plugin getPlugin(String name) {
        List plugins = this.project.getModel().getBuild().getPlugins();
        for (Object plugin : plugins) {
            if (!((Plugin)plugin).getArtifactId().equals(name)) continue;
            return (Plugin)plugin;
        }
        return null;
    }

    private List<PluginExecution> getGoals(Plugin plugin, String goalName) {
        List executions = plugin.getExecutions();
        ArrayList<PluginExecution> goals = new ArrayList<PluginExecution>();
        for (Object execution : executions) {
            PluginExecution pe = (PluginExecution)execution;
            List allGoals = pe.getGoals();
            for (Object goal : allGoals) {
                if (!((String)goal).equals(goalName)) continue;
                goals.add(pe);
            }
        }
        return goals;
    }

    private Properties getConfigurations(PluginExecution goal, Plugin plugin, String ... nonLeafNodeNames) {
        Xpp3Dom config = (Xpp3Dom)plugin.getConfiguration();
        Properties configurations = this.getConfigurations(config);
        if (nonLeafNodeNames != null) {
            for (String nonLeafNodeName : nonLeafNodeNames) {
                configurations.put(nonLeafNodeName, this.getConfigurationsAsList(config.getChild(nonLeafNodeName)));
            }
        }
        if ((config = (Xpp3Dom)goal.getConfiguration()) != null) {
            configurations.putAll((Map<?, ?>)this.getConfigurations(config));
            for (String nonLeafNodeName : nonLeafNodeNames) {
                List value = (List)configurations.get(nonLeafNodeName);
                value.addAll(this.getConfigurationsAsList(config.getChild(nonLeafNodeName)));
                configurations.put(nonLeafNodeName, value);
            }
        }
        return configurations;
    }

    private Properties getConfigurations(Xpp3Dom node) {
        Xpp3Dom[] configs;
        Properties properties = new Properties();
        if (node != null && (configs = node.getChildren()) != null) {
            for (Xpp3Dom config : configs) {
                if (config.getValue() == null) continue;
                properties.setProperty(config.getName(), config.getValue());
            }
        }
        return properties;
    }

    private List<String> getConfigurationsAsList(Xpp3Dom node) {
        Xpp3Dom[] configs;
        ArrayList<String> configurations = new ArrayList<String>();
        if (node != null && (configs = node.getChildren()) != null) {
            for (Xpp3Dom config : configs) {
                if (config.getValue() == null) continue;
                configurations.add(config.getValue());
            }
        }
        return configurations;
    }

    public void runCommand(String serverId, ClassLoader cl, String[] commandLines) throws Exception {
        Class<?> clazz = cl.loadClass(PluginUtil.class.getName());
        Method m = clazz.getMethod("runCommand", String.class, String[].class);
        m.invoke(null, serverId, commandLines);
    }
}

