/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.arp;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.SocketChannelOutputBuffer;
import com.sun.grizzly.tcp.Response;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class AsynchronousOutputBuffer
extends SocketChannelOutputBuffer {
    private ReentrantLock byteBufferWriteLock = new ReentrantLock();

    public AsynchronousOutputBuffer(Response response, int headerBufferSize, boolean useSocketBuffer) {
        super(response, headerBufferSize, useSocketBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realWriteBytes(byte[] cbuf, int off, int len) throws IOException {
        try {
            this.byteBufferWriteLock.lock();
            super.realWriteBytes(cbuf, off, len);
        }
        finally {
            this.byteBufferWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushChannel(ByteBuffer bb) throws IOException {
        try {
            this.byteBufferWriteLock.lock();
            super.flushChannel(bb);
        }
        catch (IOException ex) {
            if (!ex.getMessage().startsWith("Illegal")) {
                throw ex;
            }
            if (SelectorThread.logger().isLoggable(Level.FINEST)) {
                SelectorThread.logger().log(Level.FINEST, "", ex);
            }
        }
        finally {
            this.byteBufferWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        try {
            this.byteBufferWriteLock.lock();
            super.flush();
        }
        finally {
            this.byteBufferWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        try {
            this.byteBufferWriteLock.lock();
            super.flushBuffer();
        }
        finally {
            this.byteBufferWriteLock.unlock();
        }
    }
}

