/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.logging.LogDomains;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.impl.client.Strings;

final class AgentAttacherInternal {
    private static final Object syncOnMe = new Object();
    private static final Logger logger = LogDomains.getLogger(AgentAttacherInternal.class, (String)"javax.enterprise.system.tools.monitor");
    private static boolean isAttached = false;

    AgentAttacherInternal() {
    }

    static boolean isAttached() {
        return isAttached;
    }

    static boolean attachAgent() {
        return AgentAttacherInternal.attachAgent(-1, "");
    }

    static boolean attachAgent(int pid, String options) {
        try {
            if (isAttached) {
                return true;
            }
            if (pid < 0) {
                pid = ProcessUtils.getPid();
            }
            if (pid < 0) {
                logger.warning(Strings.get("invalid.pid"));
                return false;
            }
            VirtualMachine vm = VirtualMachine.attach(String.valueOf(pid));
            String ir = System.getProperty("com.sun.aas.installRoot");
            File dir = new File(ir, "lib" + File.separator + "monitor");
            if (!dir.isDirectory()) {
                logger.warning(Strings.get("missing.agent.jar.dir", dir));
                return false;
            }
            File agentJar = new File(dir, "flashlight-agent.jar");
            if (!agentJar.isFile()) {
                logger.log(Level.WARNING, Strings.get("missing.agent.jar", dir));
                return false;
            }
            vm.loadAgent(SmartFile.sanitize((String)agentJar.getPath()), options);
            isAttached = true;
        }
        catch (Throwable t) {
            logger.warning(Strings.get("attach.agent.exception", t.getMessage()));
            isAttached = false;
        }
        return isAttached;
    }
}

