/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.glassfish.flashlight.FlashlightUtils;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.impl.core.ComputedParamsHandlerManager;
import org.glassfish.flashlight.provider.FlashlightProbe;

public class ReflectiveClientInvoker
implements ProbeClientInvoker {
    private int id;
    private Object target;
    private Method method;
    private String[] paramNames;
    boolean hasComputedParams;
    int[] probeIndices;
    boolean useProbeArgs;
    Class[] methodParamTypes;
    boolean emittedOneMessage = false;

    public ReflectiveClientInvoker(int id, Object target, Method method, String[] clientParamNames, FlashlightProbe probe) {
        int index;
        this.id = id;
        this.target = target;
        this.method = method;
        this.paramNames = clientParamNames;
        this.methodParamTypes = method.getParameterTypes();
        int size = clientParamNames.length;
        this.probeIndices = new int[size];
        String[] probeParamNames = probe.getProbeParamNames();
        HashMap<String, Integer> probeParamIndexMap = new HashMap<String, Integer>();
        for (index = 0; index < probeParamNames.length; ++index) {
            probeParamIndexMap.put(probeParamNames[index], index);
        }
        for (index = 0; index < size; ++index) {
            int actualIndex;
            if (clientParamNames[index].startsWith("$")) {
                this.hasComputedParams = true;
                this.probeIndices[index] = -1;
                continue;
            }
            this.probeIndices[index] = actualIndex = ((Integer)probeParamIndexMap.get(clientParamNames[index])).intValue();
        }
        if (!this.hasComputedParams) {
            this.useProbeArgs = true;
            for (index = 0; index < size; ++index) {
                int probeParamIndex = (Integer)probeParamIndexMap.get(this.paramNames[index]);
                if (index == probeParamIndex) continue;
                this.useProbeArgs = false;
                break;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id=").append(this.id).append('\n');
        sb.append("target=").append(this.target).append('\n');
        sb.append("method=").append(this.method).append('\n');
        sb.append("paramNames=").append(Arrays.toString(this.paramNames)).append('\n');
        sb.append("probeIndices=").append(Arrays.toString(this.probeIndices)).append('\n');
        sb.append("useProbeArgs=").append(this.useProbeArgs).append('\n');
        sb.append("hasComputedParams=").append(this.hasComputedParams).append('\n');
        return sb.toString();
    }

    public int getId() {
        return this.id;
    }

    public void invoke(Object[] args) {
        block10: {
            if (!FlashlightUtils.isMonitoringEnabled()) {
                return;
            }
            try {
                if (!this.useProbeArgs) {
                    if (this.hasComputedParams) {
                        ComputedParamsHandlerManager cphm = ComputedParamsHandlerManager.getInstance();
                        int size = this.paramNames.length;
                        Object[] tempArgs = args;
                        args = new Object[size];
                        for (int i = 0; i < size; ++i) {
                            args[i] = this.probeIndices[i] == -1 ? cphm.computeValue(this.paramNames[i]) : tempArgs[this.probeIndices[i]];
                        }
                    } else {
                        int size = this.paramNames.length;
                        Object[] tempArgs = args;
                        args = new Object[size];
                        for (int i = 0; i < size; ++i) {
                            args[i] = tempArgs[this.probeIndices[i]];
                        }
                    }
                }
                if (this.method.isVarArgs()) {
                    this.method.invoke(this.target, new Object[]{args});
                } else {
                    this.methodInvoke(args);
                }
            }
            catch (Exception ex) {
                if (this.emittedOneMessage) break block10;
                this.emittedOneMessage = true;
                StringBuilder sb = new StringBuilder();
                sb.append(this.getClass().getName()).append('\n').append(ex).append('\n');
                sb.append("CAUSE:  ").append(ex.getCause()).append('\n');
                sb.append(this);
                System.out.println(sb.toString());
            }
        }
    }

    private void methodInvoke(Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            this.method.invoke(this.target, args);
        }
        catch (Exception e1) {
            this.matchupArgs(args);
            this.method.invoke(this.target, args);
        }
    }

    private void matchupArgs(Object[] args) {
        if (args == null || args.length == 0 || this.methodParamTypes == null || this.methodParamTypes.length == 0) {
            return;
        }
        if (args.length != this.methodParamTypes.length) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            Class<?> argClass;
            if (args[i] == null || this.methodParamTypes[i] == null || (argClass = args[i].getClass()).equals(this.methodParamTypes[i]) || this.methodParamTypes[i].isAssignableFrom(argClass) || FlashlightUtils.compareIntegralOrFloat(argClass, this.methodParamTypes[i])) continue;
            if (this.methodParamTypes[i].isAssignableFrom(String.class)) {
                args[i] = args[i].toString();
                if (this.emittedOneMessage) continue;
                System.out.println("FIXED MISMATCH!!!!\n" + this.toString());
                this.emittedOneMessage = true;
                continue;
            }
            if (this.emittedOneMessage) continue;
            System.out.printf("ERROR!  Mismatched params  Expected " + this.methodParamTypes[i].toString() + " but got " + args[i].getClass().toString() + "\n" + this.toString(), new Object[0]);
            this.emittedOneMessage = true;
        }
    }
}

