/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.osgi.httpservice;

import java.util.Dictionary;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.glassfish.grizzly.osgi.httpservice.HttpContextImpl;
import org.glassfish.grizzly.osgi.httpservice.HttpServiceExtension;
import org.glassfish.grizzly.osgi.httpservice.OSGiMainHandler;
import org.glassfish.grizzly.osgi.httpservice.util.Logger;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public class HttpServiceImpl
implements HttpServiceExtension {
    private final Logger logger;
    private final Bundle bundle;
    final OSGiMainHandler mainHttpHandler;

    public HttpServiceImpl(Bundle bundle, Logger logger) {
        this.bundle = bundle;
        this.logger = logger;
        this.mainHttpHandler = new OSGiMainHandler(logger, bundle);
    }

    public HttpContext createDefaultHttpContext() {
        return new HttpContextImpl(this.bundle);
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext) throws ServletException, NamespaceException {
        this.logger.info("Registering servlet: " + servlet + ", under: " + alias + ", with: " + initparams + " and context: " + httpContext);
        this.mainHttpHandler.registerServletHandler(alias, servlet, initparams, httpContext, this);
    }

    public void registerResources(String alias, String prefix, HttpContext httpContext) throws NamespaceException {
        this.logger.info("Registering resource: alias: " + alias + ", prefix: " + prefix + " and context: " + httpContext);
        this.mainHttpHandler.registerResourceHandler(alias, httpContext, prefix, this);
    }

    public void unregister(String alias) {
        this.logger.info("Unregistering alias: " + alias);
        this.mainHttpHandler.unregisterAlias(alias);
    }

    @Override
    public void registerFilter(Filter filter, String urlPattern, Dictionary initParams, HttpContext context) throws ServletException {
        this.logger.info("Registering servlet: " + filter + ", under url-pattern: " + urlPattern + ", with: " + initParams + " and context: " + context);
        this.mainHttpHandler.registerFilter(filter, urlPattern, initParams, context, this);
    }

    @Override
    public void unregisterFilter(Filter filter) {
        this.logger.info("Unregister filter: " + filter);
        this.mainHttpHandler.unregisterFilter(filter);
    }
}

