/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyConfiguration;
import org.glassfish.jersey.client.JerseyInvocation;

public class Target
implements javax.ws.rs.client.Target {
    private final JerseyConfiguration configuration;
    private final UriBuilder targetUri;
    private final Map<String, Object> pathParams;
    private final JerseyClient client;

    Target(String uri, JerseyClient parent) {
        this(UriBuilder.fromUri((String)uri), null, parent.configuration().snapshot(), parent);
    }

    Target(URI uri, JerseyClient parent) {
        this(UriBuilder.fromUri((URI)uri), null, parent.configuration().snapshot(), parent);
    }

    Target(UriBuilder uriBuilder, JerseyClient parent) {
        this(uriBuilder.clone(), null, parent.configuration().snapshot(), parent);
    }

    Target(Link link, JerseyClient parent) {
        this(UriBuilder.fromUri((URI)link.getUri()), null, parent.configuration().snapshot(), parent);
    }

    protected Target(UriBuilder targetUri, Target that) {
        this(targetUri, that.pathParams, that.configuration.snapshot(), that.client);
    }

    protected Target(UriBuilder targetUri, @Nullable Map<String, Object> pathParams, JerseyConfiguration jerseyConfiguration, JerseyClient client) {
        this.targetUri = targetUri;
        this.pathParams = pathParams != null ? Maps.newHashMap(pathParams) : Maps.newHashMap();
        this.configuration = jerseyConfiguration;
        this.client = client;
    }

    protected final void setPathParam(String name, Object value) {
        if (value == null) {
            this.pathParams.remove(name);
        } else {
            this.pathParams.put(name, value);
        }
    }

    protected final void replacePathParams(Map<String, Object> params) {
        this.pathParams.clear();
        if (params != null) {
            this.pathParams.putAll(params);
        }
    }

    public URI getUri() {
        return this.targetUri.buildFromMap(this.pathParams);
    }

    public UriBuilder getUriBuilder() {
        return this.targetUri.clone();
    }

    public JerseyConfiguration configuration() {
        return this.configuration;
    }

    public Target path(String path) throws NullPointerException {
        return new Target(this.getUriBuilder().path(path), this);
    }

    public Target pathParam(String name, Object value) throws IllegalArgumentException, NullPointerException {
        Target result = new Target(this.getUriBuilder(), this);
        result.setPathParam(name, value);
        return result;
    }

    public Target pathParams(Map<String, Object> parameters) throws IllegalArgumentException, NullPointerException {
        Target result = new Target(this.getUriBuilder(), this);
        result.replacePathParams(parameters);
        return result;
    }

    public Target matrixParam(String name, Object ... values) throws NullPointerException {
        return new Target(this.getUriBuilder().matrixParam(name, values), this);
    }

    public Target queryParam(String name, Object ... values) throws NullPointerException {
        return new Target(this.getUriBuilder().queryParam(name, values), this);
    }

    public Target queryParams(MultivaluedMap<String, Object> parameters) throws IllegalArgumentException, NullPointerException {
        UriBuilder ub = this.getUriBuilder();
        for (Map.Entry e : parameters.entrySet()) {
            ub.queryParam((String)e.getKey(), ((List)e.getValue()).toArray());
        }
        return new Target(ub, this);
    }

    public JerseyInvocation.Builder request() {
        return new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot(), this.client);
    }

    public JerseyInvocation.Builder request(String ... acceptedResponseTypes) {
        JerseyInvocation.Builder b = new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot(), this.client);
        b.request().accept(acceptedResponseTypes);
        return b;
    }

    public JerseyInvocation.Builder request(MediaType ... acceptedResponseTypes) {
        JerseyInvocation.Builder b = new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot(), this.client);
        b.request().accept(acceptedResponseTypes);
        return b;
    }
}

