/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.Requests;

public class RequestWriter {
    private static final Logger LOGGER = Logger.getLogger(RequestWriter.class.getName());
    protected static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    protected RequestEntityWriter getRequestEntityWriter(Request request) {
        return new RequestEntityWriterImpl(request);
    }

    protected void writeRequestEntity(Request request, RequestEntityWriterListener listener) throws IOException {
        Class<?> entityType;
        Object entity = request.getEntity();
        if (entity == null) {
            return;
        }
        if (entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)entity;
            entity = ge.getEntity();
            entityType = ge.getType();
        } else {
            Class<?> genericSuperclass = entity.getClass().getGenericSuperclass();
            entityType = genericSuperclass instanceof ParameterizedType ? genericSuperclass : entity.getClass();
        }
        Class<?> entityClass = entity.getClass();
        request = this.ensureMediaType(entityClass, entityType, request);
        MediaType mediaType = request.getHeaders().getMediaType();
        MultivaluedMap headers = request.getHeaders().asMap();
        RequestEntityWriterListener sizeCallback = null;
        if (headers.containsKey((Object)"Content-Encoding")) {
            listener.onRequestEntitySize(-1L);
        } else {
            sizeCallback = listener;
        }
        MessageBodyWorkers workers = Requests.getMessageWorkers((Request)request);
        OutputStream out = listener.onGetOutputStream();
        try {
            workers.writeTo(entity, GenericType.of(entityClass, entityType), EMPTY_ANNOTATIONS, mediaType, headers, request.getProperties(), out, (MessageBodyWorkers.MessageBodySizeCallback)sizeCallback, true);
        }
        catch (IOException ex) {
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw ex;
        }
        out.close();
    }

    private Request ensureMediaType(Class<?> entityClass, Type entityType, Request request) {
        if (request.getHeaders().getMediaType() != null) {
            return request;
        }
        List mediaTypes = Requests.getMessageWorkers((Request)request).getMessageBodyWriterMediaTypes(entityClass, entityType, EMPTY_ANNOTATIONS);
        MediaType mediaType = this.getMediaType(mediaTypes);
        return Requests.from((Request)request).type(mediaType).build();
    }

    private MediaType getMediaType(List<MediaType> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        MediaType mediaType = mediaTypes.get(0);
        if (mediaType.isWildcardType() || mediaType.isWildcardSubtype()) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        return mediaType;
    }

    private final class RequestEntityWriterImpl
    implements RequestEntityWriter {
        private final Request request;
        private final Object entity;
        private final Type entityType;
        private final MediaType mediaType;
        private final long size;
        private final MessageBodyWriter writer;

        public RequestEntityWriterImpl(Request request) {
            this.request = request;
            Object e = request.getEntity();
            if (e == null) {
                throw new IllegalArgumentException("The entity of the client request is null");
            }
            if (e instanceof GenericEntity) {
                GenericEntity ge = (GenericEntity)e;
                this.entity = ge.getEntity();
                this.entityType = ge.getType();
            } else {
                this.entity = e;
                Class<?> genericSuperclass = this.entity.getClass().getGenericSuperclass();
                this.entityType = genericSuperclass instanceof ParameterizedType ? genericSuperclass : this.entity.getClass();
            }
            Class<?> entityClass = this.entity.getClass();
            request = RequestWriter.this.ensureMediaType(entityClass, this.entityType, request);
            this.mediaType = request.getHeaders().getMediaType();
            MessageBodyWorkers workers = Requests.getMessageWorkers((Request)request);
            this.writer = workers.getMessageBodyWriter(entityClass, this.entityType, EMPTY_ANNOTATIONS, this.mediaType);
            if (this.writer == null) {
                String message = "A message body writer for Java class " + entityClass.getName() + ", and Java type " + this.entityType + ", and MIME media type " + this.mediaType + " was not found";
                LOGGER.severe(message);
                Map m = workers.getWriters(this.mediaType);
                LOGGER.log(Level.SEVERE, "The registered message body writers compatible with the MIME media type are:\n{0}", workers.writersToString(m));
                throw new ClientException(message);
            }
            MultivaluedMap headers = request.getHeaders().asMap();
            this.size = headers.containsKey((Object)"Content-Encoding") ? -1L : this.writer.getSize(this.entity, entityClass, this.entityType, EMPTY_ANNOTATIONS, this.mediaType);
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public MediaType getMediaType() {
            return this.mediaType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeRequestEntity(OutputStream out) throws IOException {
            try {
                this.writer.writeTo(this.entity, this.entity.getClass(), this.entityType, EMPTY_ANNOTATIONS, this.mediaType, this.request.getHeaders().asMap(), out);
                out.flush();
            }
            finally {
                out.close();
            }
        }
    }

    protected static interface RequestEntityWriter {
        public long getSize();

        public MediaType getMediaType();

        public void writeRequestEntity(OutputStream var1) throws IOException;
    }

    protected static interface RequestEntityWriterListener
    extends MessageBodyWorkers.MessageBodySizeCallback {
        public OutputStream onGetOutputStream() throws IOException;
    }
}

